/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.entity.mob.misc.HydrolonEntity;

public class HydroliskEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private static final DataParameter<Boolean> SHIELDED = EntityDataManager.func_187226_a(HydroliskEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private boolean shielded = true;

    public HydroliskEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AoAMinion.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.625f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHIELDED, (Object)true);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 609.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 12.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_HYDROLISK_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_HYDROLISK_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_HYDROLISK_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_EMPEROR_BEAST_STEP.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_190530_aW() {
        return super.func_190530_aW() || this.isShielded();
    }

    public boolean func_180431_b(DamageSource source) {
        return this.func_190530_aW() || super.func_180431_b(source);
    }

    public boolean isShielded() {
        return (Boolean)this.field_70180_af.func_187225_a(SHIELDED);
    }

    private void disableShield() {
        this.field_70180_af.func_187227_b(SHIELDED, (Object)false);
        this.shielded = false;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(800.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(16.0);
        this.func_70606_j(800.0f);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_175446_cd()) {
            return;
        }
        if (this.func_70090_H()) {
            this.func_70691_i(1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.shielded) {
                if (this.field_70146_Z.nextInt(80) == 0) {
                    this.field_70170_p.func_217376_c((Entity)new HydrolonEntity(this));
                }
            } else if (this.field_70146_Z.nextInt(120) == 0 && !this.field_70170_p.func_201675_m().func_177500_n() && this.field_70170_p.func_180495_p(this.func_180425_c()).func_185904_a().func_76222_j()) {
                this.field_70170_p.func_175656_a(this.func_180425_c(), (BlockState)Blocks.field_150355_j.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(14)));
            }
        }
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldItem;
        if (this.shielded && (heldItem = player.func_184586_b(hand)).func_77973_b() == AoAItems.HYDRO_STONE.get()) {
            if (!player.func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
            if (this.func_110143_aJ() <= 50.0f) {
                this.disableShield();
            } else {
                this.func_70606_j(this.func_110143_aJ() - 50.0f);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.HYDROLISK_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.HYDROLISK_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

