/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.MechFallEntity;
import net.tslat.aoa3.entity.projectile.mob.MechShotEntity;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class MechbotEntity
extends AoAMeleeMob
implements AoARangedAttacker {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private int jumpCooldown = 200;
    private int jumpCount = 0;
    private int jumpIntervalTimer = 0;

    public MechbotEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.21875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.9;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_MECHYON_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_MECHYON_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_MECHYON_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70638_az() == null || !this.func_70089_S()) {
            return;
        }
        LivingEntity target = this.func_70638_az();
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (this.jumpCooldown <= 0) {
            if (this.jumpCount < 4) {
                --this.jumpIntervalTimer;
                if (this.jumpIntervalTimer <= 0) {
                    this.func_213293_j((target.func_226277_ct_() - this.func_226277_ct_()) * 0.0459, 0.69, (target.func_226281_cx_() - this.func_226281_cx_()) * 0.045);
                    this.field_70133_I = true;
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_MECHBOT_JUMP.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                        this.field_70170_p.func_217376_c((Entity)new MechFallEntity(this, this.func_226277_ct_(), this.func_226278_cu_() - 0.25, this.func_226281_cx_(), BaseMobProjectile.Type.MAGIC));
                        if (this.func_110143_aJ() < 1250.0f) {
                            this.field_70170_p.func_217376_c((Entity)new MechFallEntity(this, this.func_226277_ct_() - 2.25, this.func_226278_cu_() - 0.25, this.func_226281_cx_() - 2.25, BaseMobProjectile.Type.MAGIC));
                            this.field_70170_p.func_217376_c((Entity)new MechFallEntity(this, this.func_226277_ct_() - 2.25, this.func_226278_cu_() - 0.25, this.func_226281_cx_() + 2.25, BaseMobProjectile.Type.MAGIC));
                            this.field_70170_p.func_217376_c((Entity)new MechFallEntity(this, this.func_226277_ct_() + 2.25, this.func_226278_cu_() - 0.25, this.func_226281_cx_() - 2.25, BaseMobProjectile.Type.MAGIC));
                            this.field_70170_p.func_217376_c((Entity)new MechFallEntity(this, this.func_226277_ct_() + 2.25, this.func_226278_cu_() - 0.25, this.func_226281_cx_() + 2.25, BaseMobProjectile.Type.MAGIC));
                        }
                    }
                    ++this.jumpCount;
                    this.jumpIntervalTimer = 15;
                }
            } else {
                this.jumpCooldown = 200;
                this.jumpCount = 0;
                this.jumpIntervalTimer = 15;
            }
        }
        if (this.func_110143_aJ() < 1000.0f ? this.field_70146_Z.nextInt(10) == 0 : this.field_70146_Z.nextInt(40) == 0) {
            MechShotEntity projectile = new MechShotEntity(this, BaseMobProjectile.Type.MAGIC);
            double distanceFactorX = target.func_226277_ct_() - this.func_226277_ct_();
            double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - projectile.func_226278_cu_();
            double distanceFactorZ = target.func_226281_cx_() - this.func_226281_cx_();
            double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_MECHBOT_SHOOT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
            this.field_70170_p.func_217376_c((Entity)projectile);
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.mechbot.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (DamageUtil.dealBlasterDamage((LivingEntity)this, target, (Entity)projectile, 5.0f, false)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 1.0f);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.MECHBOT_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.MECHBOT_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

