/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.NethengeicWitherShotEntity;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class NethengeicWitherEntity
extends MonsterEntity
implements IRangedAttackMob,
AoARangedAttacker {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.func_187226_a(NethengeicWitherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.func_187226_a(NethengeicWitherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.func_187226_a(NethengeicWitherEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private static final EntityPredicate NOT_UNDEAD = new EntityPredicate().func_221013_a(20.0).func_221012_a(entity -> entity.func_70668_bt() != CreatureAttribute.field_223223_b_ && entity.func_190631_cK());
    private final float[] xRotationHeads = new float[2];
    private final float[] yRotationHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    public static final float entityWidth = 1.3f;
    private int attackCooldown = 45;

    public NethengeicWitherEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.func_70661_as().func_212239_d(true);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.484375f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 1, 10, 32.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AoAMinion.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(52.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRST_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(SECOND_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(THIRD_HEAD_TARGET, (Object)0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_WITHER_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_WITHER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_WITHER_HURT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70636_d() {
        int i;
        Entity primaryTarget;
        Vec3d motion = this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0);
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (primaryTarget = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            double yVelocity = motion.field_72448_b;
            if (this.func_226278_cu_() < primaryTarget.func_226278_cu_() || this.func_226278_cu_() < primaryTarget.func_226278_cu_() + 5.0) {
                yVelocity = Math.max(0.0, yVelocity);
                yVelocity += 0.3 - yVelocity * (double)0.6f;
            }
            motion = new Vec3d(motion.field_72450_a, yVelocity, motion.field_72449_c);
            Vec3d targetVec = new Vec3d(primaryTarget.func_226277_ct_() - this.func_226277_ct_(), 0.0, primaryTarget.func_226281_cx_() - this.func_226281_cx_());
            if (NethengeicWitherEntity.func_213296_b((Vec3d)targetVec) > 9.0) {
                targetVec = targetVec.func_72432_b();
                motion = motion.func_72441_c(targetVec.field_72450_a * 0.3 - motion.field_72450_a * 0.6, 0.0, targetVec.field_72449_c * 0.3 - motion.field_72449_c * 0.6);
            }
        }
        this.func_213317_d(motion);
        if (NethengeicWitherEntity.func_213296_b((Vec3d)motion) > 0.05) {
            this.field_70177_z = (float)MathHelper.func_181159_b((double)motion.field_72449_c, (double)motion.field_72450_a) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (int headId = 0; headId < 2; ++headId) {
            int nextTargetID = this.getWatchedTargetId(headId + 1);
            Entity target = null;
            if (nextTargetID > 0) {
                target = this.field_70170_p.func_73045_a(nextTargetID);
            }
            if (target != null) {
                double headX = this.getHeadX(headId + 1);
                double headY = this.getHeadY(headId + 1);
                double headZ = this.getHeadZ(headId + 1);
                double headTargetDistanceX = target.func_226277_ct_() - headX;
                double headTargetDistanceY = target.func_226280_cw_() - headY;
                double headTargetDistanceZ = target.func_226281_cx_() - headZ;
                double targetDistance = MathHelper.func_76133_a((double)(headTargetDistanceX * headTargetDistanceX + headTargetDistanceZ * headTargetDistanceZ));
                float f = (float)(MathHelper.func_181159_b((double)headTargetDistanceZ, (double)headTargetDistanceX) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.func_181159_b((double)headTargetDistanceY, (double)targetDistance) * 57.2957763671875));
                this.xRotationHeads[headId] = this.clampRotation(this.xRotationHeads[headId], f1, 40.0f);
                this.yRotationHeads[headId] = this.clampRotation(this.yRotationHeads[headId], f, 10.0f);
                continue;
            }
            this.yRotationHeads[headId] = this.clampRotation(this.yRotationHeads[headId], this.field_70761_aq, 10.0f);
        }
        for (i = 0; i < 3; ++i) {
            double nextHeadX = this.getHeadX(i);
            double nextHeadY = this.getHeadY(i);
            double nextHeadZ = this.getHeadZ(i);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, nextHeadX - this.field_70146_Z.nextGaussian() * 0.3, nextHeadY + this.field_70146_Z.nextGaussian() * 0.3, nextHeadZ + this.field_70146_Z.nextGaussian() * 0.3, 0.0, 0.0, 0.0);
        }
        if (this.getStage() > 1 && this.func_110143_aJ() > 0.0f) {
            this.func_70691_i(0.3f);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        block0: for (int i = 1; i < 3; ++i) {
            int targetId;
            if (this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
            if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                int prevHeadId = i - 1;
                int idleHeadUpdate = this.idleHeadUpdates[prevHeadId];
                this.idleHeadUpdates[prevHeadId] = this.idleHeadUpdates[prevHeadId] + 1;
                if (idleHeadUpdate > 15) {
                    double targetPosX = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226277_ct_() - 10.0), (double)(this.func_226277_ct_() + 10.0));
                    double targetPosY = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226278_cu_() - 5.0), (double)(this.func_226278_cu_() + 5.0));
                    double targetPosZ = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226281_cx_() - 10.0), (double)(this.func_226281_cx_() + 10.0));
                    this.shootAtBlockPos(i + 1, targetPosX, targetPosY, targetPosZ);
                    this.idleHeadUpdates[prevHeadId] = 0;
                }
            }
            if ((targetId = this.getWatchedTargetId(i)) > 0) {
                Entity entity = this.field_70170_p.func_73045_a(targetId);
                if (entity != null && entity.func_70089_S() && !(this.func_70068_e(entity) > 900.0) && this.func_70685_l(entity)) {
                    if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75102_a) {
                        this.setWatchedTargetId(i, 0);
                        continue;
                    }
                    this.shootAtTarget(i + 1, (LivingEntity)entity);
                    this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                    this.idleHeadUpdates[i - 1] = 0;
                    continue;
                }
                this.setWatchedTargetId(i, 0);
                continue;
            }
            List list = this.field_70170_p.func_217374_a(LivingEntity.class, NOT_UNDEAD, (LivingEntity)this, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0));
            for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                LivingEntity entity = (LivingEntity)list.get(this.field_70146_Z.nextInt(list.size()));
                if (entity != this && entity.func_70089_S() && !entity.func_70662_br() && this.func_70685_l((Entity)entity)) {
                    if (entity instanceof PlayerEntity) {
                        if (((PlayerEntity)entity).field_71075_bZ.field_75102_a) continue block0;
                        this.setWatchedTargetId(i, entity.func_145782_y());
                        continue block0;
                    }
                    this.setWatchedTargetId(i, entity.func_145782_y());
                    continue block0;
                }
                list.remove(entity);
            }
        }
        if (this.func_70638_az() != null) {
            this.setWatchedTargetId(0, this.func_70638_az().func_145782_y());
        } else {
            this.setWatchedTargetId(0, 0);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    private double getHeadX(int head) {
        if (head <= 0) {
            return this.func_226277_ct_();
        }
        return this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)((this.field_70761_aq + (float)(180 * (head - 1))) * ((float)Math.PI / 180))) * 1.3;
    }

    private double getHeadY(int head) {
        return this.func_226278_cu_() + 3.0;
    }

    private double getHeadZ(int head) {
        if (head <= 0) {
            return this.func_226281_cx_();
        }
        return this.func_226277_ct_() + (double)MathHelper.func_76126_a((float)((this.field_70761_aq + (float)(180 * (head - 1))) * ((float)Math.PI / 180))) * 1.3;
    }

    private float clampRotation(float xRotationOld, float xRotationNew, float max) {
        float degrees = MathHelper.func_76142_g((float)(xRotationNew - xRotationOld));
        return xRotationOld + MathHelper.func_76131_a((float)degrees, (float)(-max), (float)max);
    }

    private void shootAtBlockPos(int head, double posX, double posY, double posZ) {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        } else {
            this.attackCooldown = this.getAttackCooldown();
            NethengeicWitherShotEntity projectile = new NethengeicWitherShotEntity(this, this.getStage() == 3);
            double distanceFactorX = posX - projectile.func_226277_ct_();
            double distanceFactorY = posY - projectile.func_226278_cu_();
            double distanceFactorZ = posZ - projectile.func_226281_cx_();
            double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
            projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
            this.field_70170_p.func_217376_c((Entity)projectile);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return false;
    }

    public int getStage() {
        if (this.func_110143_aJ() > 550.0f) {
            return 1;
        }
        if (this.func_110143_aJ() > 220.0f) {
            return 2;
        }
        return 3;
    }

    private int getAttackCooldown() {
        switch (this.getStage()) {
            default: {
                return 45;
            }
            case 2: {
                return 20;
            }
            case 3: 
        }
        return 7;
    }

    private void shootAtTarget(int head, LivingEntity target) {
        this.shootAtBlockPos(head, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e() + 0.5, target.func_226281_cx_());
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.shootAtTarget(0, target);
    }

    public void func_184609_a(Hand hand) {
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source.func_76346_g() instanceof NethengeicWitherEntity || DamageUtil.isMagicDamage(source, (Entity)this, 1.0f) || source.func_94541_c() || source.func_76347_k() || super.func_180431_b(source);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadYRotation(int head) {
        return this.yRotationHeads[head];
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadXRotation(int head) {
        return this.xRotationHeads[head];
    }

    public int getWatchedTargetId(int head) {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TARGETS[head]);
    }

    public void setWatchedTargetId(int head, int entityId) {
        this.field_70180_af.func_187227_b(HEAD_TARGETS[head], (Object)entityId);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.nethengeicWither.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        DamageSource damageSource = DamageSource.func_188403_a((Entity)projectile, (LivingEntity)this);
        float f = projectile instanceof NethengeicWitherShotEntity ? (((NethengeicWitherShotEntity)projectile).cataclysmic ? 30.0f : 20.0f) : 20.0f;
        if (target.func_70097_a(damageSource, f)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof LivingEntity && projectile instanceof NethengeicWitherShotEntity) {
            if (((NethengeicWitherShotEntity)projectile).cataclysmic) {
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 70).level(3));
            } else {
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 90).level(2));
            }
        }
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.NETHENGEIC_WITHER_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.NETHENGEIC_WITHER_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

