/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.mob.abyss.ApparitionEntity;
import net.tslat.aoa3.entity.mob.abyss.OcculentEntity;
import net.tslat.aoa3.entity.mob.dustopia.BasiliskEntity;
import net.tslat.aoa3.entity.mob.dustopia.DevourerEntity;
import net.tslat.aoa3.entity.mob.dustopia.StalkerEntity;
import net.tslat.aoa3.entity.mob.greckon.ShifterEntity;
import net.tslat.aoa3.entity.mob.nether.HellspotEntity;
import net.tslat.aoa3.entity.mob.voxponds.AlarmoEntity;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.PenumbraShotEntity;
import net.tslat.aoa3.util.RandomUtil;

public class PenumbraEntity
extends AoARangedMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);

    public PenumbraEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 3.0625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 18.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_PENUMBRA_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_PENUMBRA_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_PENUMBRA_HURT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        EntityType type = target.func_200600_R();
        if (type == AoAEntities.Mobs.OCCULENT.get() || type == AoAEntities.Mobs.ALARMO.get() || type == AoAEntities.Mobs.SHIFTER.get() || type == AoAEntities.Mobs.DEVOURER.get() || type == AoAEntities.Mobs.BASILISK.get() || type == AoAEntities.Mobs.APPARITION.get() || type == AoAEntities.Mobs.STALKER.get() || type == AoAEntities.Mobs.HELLSPOT.get()) {
            return;
        }
        super.doProjectileEntityImpact(projectile, target);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        Entity entity = null;
        entity = (Entity)RandomUtil.getRandomSelection(new AoAMeleeMob[]{new OcculentEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.OCCULENT.get()), this.field_70170_p), new AlarmoEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ALARMO.get()), this.field_70170_p), new ShifterEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SHIFTER.get()), this.field_70170_p), new DevourerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.DEVOURER.get()), this.field_70170_p), new BasiliskEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.BASILISK.get()), this.field_70170_p), new ApparitionEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.APPARITION.get()), this.field_70170_p), new StalkerEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.STALKER.get()), this.field_70170_p), new HellspotEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.HELLSPOT.get()), this.field_70170_p)});
        entity.func_70107_b(projectile.func_226277_ct_(), projectile.func_226278_cu_(), projectile.func_226281_cx_());
        this.field_70170_p.func_217376_c(entity);
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new PenumbraShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.PENUMBRA_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.PENUMBRA_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

