/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.HarkosEntity;
import net.tslat.aoa3.entity.boss.OkazorEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;

public class RaxxanEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);

    public RaxxanEntity(HarkosEntity raxxan) {
        this((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.RAXXAN.get()), raxxan.field_70170_p);
        this.func_70012_b(raxxan.func_226277_ct_(), raxxan.func_226278_cu_(), raxxan.func_226281_cx_(), raxxan.field_70177_z, raxxan.field_70125_A);
    }

    public RaxxanEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.isSlipperyMovement = true;
        this.func_70659_e(1.4f);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.009375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_PRIMORDIAL_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_PRIMORDIAL_DEATH.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(100) == 0) {
                PlayerEntity nearestTarget = this.field_70170_p.func_217366_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 30.0, false);
                if (nearestTarget != null && !nearestTarget.func_184812_l_()) {
                    EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76431_k, 100));
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), (SoundEvent)AoASounds.ENTITY_VOXXULON_AMBIENT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            } else if (this.field_70146_Z.nextInt(100) == 0) {
                EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76441_p, 25));
                EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76441_p, 25));
            } else if (this.field_70146_Z.nextInt(200) == 0) {
                this.func_70691_i(100.0f);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            OkazorEntity okazor = new OkazorEntity(this);
            this.field_70170_p.func_217376_c((Entity)okazor);
            this.func_70106_y();
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.PRIMORDIAL_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.PRIMORDIAL_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

