/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class RockRiderEntity
extends AoAMeleeMob {
    private static final DataParameter<Boolean> ALTERNATE_FORM = EntityDataManager.func_187226_a(RockRiderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private boolean alternateForm = false;
    private int formCooldown = 300;

    public RockRiderEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.isSlipperyMovement = true;
        this.func_70659_e(0.8f);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 3.0625f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ALTERNATE_FORM, (Object)false);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.9;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 30.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_ROCK_RIDER_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_ROCK_RIDER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    private void changeForm(boolean alternate) {
        if (alternate) {
            this.formCooldown = 300;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(ALTERNATE_FORM, (Object)true);
            }
        } else {
            this.formCooldown = 300;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(ALTERNATE_FORM, (Object)false);
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        if ((Boolean)this.field_70180_af.func_187225_a(ALTERNATE_FORM) != false ? DamageUtil.isRangedDamage(source, (Entity)this, 1.0f) : DamageUtil.isMeleeDamage(source)) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean isAlternateForm() {
        return (Boolean)this.field_70180_af.func_187225_a(ALTERNATE_FORM);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.formCooldown > 0) {
            --this.formCooldown;
        } else if (this.alternateForm) {
            this.alternateForm = false;
            this.changeForm(false);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_ROCK_RIDER_SWITCH.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        } else {
            this.alternateForm = true;
            this.changeForm(true);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_ROCK_RIDER_SWITCH.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            if (this.alternateForm) {
                double resist = 1.0;
                IAttributeInstance attrib = ((LivingEntity)target).func_110148_a(SharedMonsterAttributes.field_111266_c);
                if (attrib != null) {
                    resist -= attrib.func_111126_e();
                }
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 150).level(4));
                target.func_70024_g(this.func_213322_ci().func_82615_a() * 5.0 * resist, this.func_213322_ci().func_82617_b() * resist, this.func_213322_ci().func_82616_c() * 5.0 * resist);
                target.field_70133_I = true;
            } else {
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76437_t, 150).level(4));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.rockrider.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.ROCK_RIDER_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.ROCK_RIDER_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

