/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.ShadowlordShotEntity;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class ShadowlordEntity
extends MonsterEntity
implements IRangedAttackMob,
AoARangedAttacker {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.func_187226_a(ShadowlordEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.func_187226_a(ShadowlordEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.func_187226_a(ShadowlordEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private final float[] xRotationHeads = new float[2];
    private final float[] yRotationHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];

    public ShadowlordEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.func_70661_as().func_212239_d(true);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 3.8375f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 20, 50, 32.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AoAMinion.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(2000.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(52.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRST_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(SECOND_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(THIRD_HEAD_TARGET, (Object)0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_SHADOWLORD_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_SHADOWLORD_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)AoASounds.ENTITY_SHADOWLORD_HURT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        int i;
        Entity target;
        Vec3d motion = this.func_213322_ci();
        double motionX = motion.func_82615_a();
        double motionY = motion.func_82617_b();
        double motionZ = motion.func_82616_c();
        motionY *= 0.6;
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (target = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            double distanceZ;
            double distanceX;
            double distanceSq;
            if (this.func_226278_cu_() < target.func_226278_cu_() + 5.0) {
                if (motionY < 0.0) {
                    motionY = 0.0;
                }
                motionY += (0.5 - motionY) * 0.6;
            }
            if ((distanceSq = (distanceX = target.func_226277_ct_() - this.func_226277_ct_()) * distanceX + (distanceZ = target.func_226281_cx_() - this.func_226281_cx_()) * distanceZ) > 9.0) {
                double distance = MathHelper.func_76133_a((double)distanceSq);
                motionX += (distanceX / distance * 0.5 - motionX) * 0.6;
                motionZ += (distanceZ / distance * 0.5 - motionZ) * 0.6;
            }
        }
        if (motionX * motionX * motionZ * motionZ > 0.05) {
            this.field_70177_z = (float)MathHelper.func_181159_b((double)motionZ, (double)motionX) * 57.295776f - 90.0f;
        }
        this.func_213317_d(new Vec3d(motionX, motionY, motionZ));
        super.func_70071_h_();
        for (i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (i = 0; i < 2; ++i) {
            Entity target2;
            int nextTargetId = this.getWatchedTargetId(i + 1);
            Entity entity = target2 = nextTargetId > 0 ? this.field_70170_p.func_73045_a(nextTargetId) : null;
            if (target2 != null) {
                double nextHeadX = this.getHeadX(i + 1);
                double nextHeadY = this.getHeadY(i + 1);
                double nextHeadZ = this.getHeadZ(i + 1);
                double distanceX = target2.func_226277_ct_() - nextHeadX;
                double distanceY = target2.func_226278_cu_() + (double)target2.func_70047_e() - nextHeadY;
                double distanceZ = target2.func_226281_cx_() - nextHeadZ;
                double distance = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
                float yRotation = (float)MathHelper.func_181159_b((double)distanceZ, (double)distanceX) * 57.295776f - 90.0f;
                float xRotation = (float)(-MathHelper.func_181159_b((double)distanceY, (double)distance) * 176.85840734641022);
                this.xRotationHeads[i] = this.clampRotation(this.xRotationHeads[i], xRotation, 40.0f);
                this.yRotationHeads[i] = this.clampRotation(this.yRotationHeads[i], yRotation, 10.0f);
                continue;
            }
            this.yRotationHeads[i] = this.clampRotation(this.yRotationHeads[i], this.field_70761_aq, 10.0f);
        }
        for (i = 0; i < 3; ++i) {
            double nextHeadX = this.getHeadX(i);
            double nextHeadY = this.getHeadY(i);
            double nextHeadZ = this.getHeadZ(i);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, nextHeadX - this.field_70146_Z.nextGaussian() * 0.3, nextHeadY + this.field_70146_Z.nextGaussian() * 0.3, nextHeadZ + this.field_70146_Z.nextGaussian() * 0.3, 0.0, 0.0, 0.0);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        block0: for (int i = 1; i < 3; ++i) {
            int targetId;
            if (this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
            if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL || this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                int head = i - 1;
                int headUpdateTime = this.idleHeadUpdates[head];
                this.idleHeadUpdates[head] = this.idleHeadUpdates[head] + 1;
                if (headUpdateTime > 15) {
                    double randPosX = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226277_ct_() - 10.0), (double)(this.func_226277_ct_() + 10.0));
                    double randPosY = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226278_cu_() - 5.0), (double)(this.func_226278_cu_() + 5.0));
                    double randPosZ = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.func_226281_cx_() - 10.0), (double)(this.func_226281_cx_() + 10.0));
                    this.idleHeadUpdates[head] = 0;
                    this.shootAtBlockPos(i + 1, randPosX, randPosY, randPosZ);
                }
            }
            if ((targetId = this.getWatchedTargetId(i)) > 0) {
                Entity target = this.field_70170_p.func_73045_a(targetId);
                if (target != null && target.func_70089_S() && target.func_70068_e(target) <= 900.0 && this.func_70685_l(target)) {
                    if (target instanceof PlayerEntity && ((PlayerEntity)target).field_71075_bZ.field_75102_a) {
                        this.setWatchedTargetId(i, 0);
                        continue;
                    }
                    this.shootAtTarget(i + 1, (LivingEntity)target);
                    this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                    this.idleHeadUpdates[i - 1] = 0;
                    continue;
                }
                this.setWatchedTargetId(i, 0);
                continue;
            }
            List targetList = this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), entity -> !entity.func_70662_br());
            for (int j = 0; j < 10 && !targetList.isEmpty(); ++j) {
                LivingEntity target = (LivingEntity)targetList.get(this.field_70146_Z.nextInt(targetList.size()));
                if (target != this && target.func_70089_S() && this.func_70685_l((Entity)target)) {
                    if (target instanceof PlayerEntity) {
                        if (((PlayerEntity)target).field_71075_bZ.field_75102_a) continue block0;
                        this.setWatchedTargetId(i, target.func_145782_y());
                        continue block0;
                    }
                    this.setWatchedTargetId(i, target.func_145782_y());
                    continue block0;
                }
                targetList.remove(target);
            }
        }
        if (this.func_70638_az() != null) {
            this.setWatchedTargetId(0, this.func_70638_az().func_145782_y());
        } else {
            this.setWatchedTargetId(0, 0);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    private double getHeadX(int head) {
        if (head <= 0) {
            return this.func_226277_ct_();
        }
        return this.func_226277_ct_() + (double)MathHelper.func_76134_b((float)((this.field_70761_aq + (float)(180 * (head - 1))) * ((float)Math.PI / 180))) * 1.3;
    }

    private double getHeadY(int head) {
        return this.func_226278_cu_() + 3.0;
    }

    private double getHeadZ(int head) {
        if (head <= 0) {
            return this.func_226281_cx_();
        }
        return this.func_226277_ct_() + (double)MathHelper.func_76126_a((float)((this.field_70761_aq + (float)(180 * (head - 1))) * ((float)Math.PI / 180))) * 1.3;
    }

    private float clampRotation(float xRotationOld, float xRotationNew, float max) {
        float degrees = MathHelper.func_76142_g((float)(xRotationNew - xRotationOld));
        return xRotationOld + MathHelper.func_76131_a((float)degrees, (float)(-max), (float)max);
    }

    private void shootAtBlockPos(int head, double posX, double posY, double posZ) {
        ShadowlordShotEntity projectile = new ShadowlordShotEntity(this, BaseMobProjectile.Type.MAGIC);
        double distanceFactorX = posX - projectile.func_226277_ct_();
        double distanceFactorY = posY - projectile.func_226278_cu_();
        double distanceFactorZ = posZ - projectile.func_226281_cx_();
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
        projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_217376_c((Entity)projectile);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public boolean func_195064_c(EffectInstance effect) {
        return false;
    }

    private void shootAtTarget(int head, LivingEntity target) {
        this.shootAtBlockPos(head, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e() + 0.5, target.func_226281_cx_());
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.shootAtTarget(0, target);
    }

    public void func_184609_a(Hand hand) {
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source.func_76346_g() instanceof ShadowlordEntity || DamageUtil.isMagicDamage(source, (Entity)this, 1.0f) || source.func_94541_c() || source.func_76347_k() || super.func_180431_b(source);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadYRotation(int head) {
        return this.yRotationHeads[head];
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHeadXRotation(int head) {
        return this.xRotationHeads[head];
    }

    public int getWatchedTargetId(int head) {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TARGETS[head]);
    }

    public void setWatchedTargetId(int head, int entityId) {
        this.field_70180_af.func_187227_b(HEAD_TARGETS[head], (Object)entityId);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.shadowlord.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (DamageUtil.dealBlasterDamage((LivingEntity)this, target, (Entity)projectile, 5.0f, false)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof LivingEntity) {
            float healthPercent = EntityUtil.getCurrentHealthPercent((LivingEntity)this);
            if ((double)healthPercent > 0.8) {
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 100).level(8), new PotionUtil.EffectBuilder(Effects.field_76436_u, 100).level(3));
            } else if ((double)healthPercent > 0.55) {
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 100).level(6), new PotionUtil.EffectBuilder(Effects.field_76436_u, 100).level(5));
            } else if ((double)healthPercent > 0.35) {
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 100).level(4));
            } else {
                if ((double)healthPercent > 0.25) {
                    EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76436_u, 100).level(7));
                } else {
                    EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 100).level(9));
                }
                EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 100).level(2));
            }
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76431_k, 100));
        }
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.SHADOWLORD_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.SHADOWLORD_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

