/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.item.armour.AdventArmour;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class SkeletronEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);

    public SkeletronEntity(World world, BlockPos armyBlockPos) {
        this((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELETRON.get()), world);
        this.func_70012_b(armyBlockPos.func_177958_n(), armyBlockPos.func_177956_o() + 2, armyBlockPos.func_177952_p(), this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
    }

    public SkeletronEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.0f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1100.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 70.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_SKELETRON_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_SKELETRON_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_SKELETRON_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.skeletalArmy.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
            if (killer instanceof ServerPlayerEntity && killer.func_184614_ca().func_77973_b() == AoAWeapons.SKELETAL_SWORD.get()) {
                for (ItemStack stack : killer.func_184193_aE()) {
                    if (stack.func_77973_b() instanceof AdventArmour && ((AdventArmour)stack.func_77973_b()).setType() == AdventArmour.Type.SKELETAL) continue;
                    return;
                }
                AdvancementUtil.completeAdvancement((ServerPlayerEntity)killer, new ResourceLocation("aoa3", "precasia/spooky_scary_skeletons"), "full_skeletal_set_skeletron_kill");
            }
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.SKELETRON_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.SKELETRON_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

