/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class TyrosaurEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private int stompCooldown = 100;

    public TyrosaurEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 0.96875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.9;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 4000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_TYROSAUR_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_TYROSAUR_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_TYROSAUR_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_TYROSAUR_STEP.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70089_S()) {
            return;
        }
        if (this.stompCooldown > 0) {
            --this.stompCooldown;
        }
        if (this.stompCooldown > 70) {
            if (this.func_70638_az() != null && this.field_70146_Z.nextInt(150) == 0) {
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_TYROSAUR_CHARGE.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
                this.func_70024_g(Math.signum(this.func_70638_az().func_226277_ct_() - this.func_226277_ct_()) * 1.029, (this.func_70638_az().func_226278_cu_() - this.func_226278_cu_()) * 0.0429, Math.signum(this.func_70638_az().func_226281_cx_() - this.func_226281_cx_()) * 1.029);
            }
        } else if (this.stompCooldown == 40) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_TYROSAUR_READY_STOMP.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
        } else if (this.stompCooldown == 0) {
            this.stompCooldown = 100;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_TYROSAUR_STOMP.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            for (PlayerEntity pl : this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(35.0), PlayerUtil::shouldPlayerBeAffected)) {
                if (!pl.field_70122_E || this.field_70170_p.field_72995_K || !DamageUtil.dealAoeDamage(null, (LivingEntity)this, (Entity)pl, 10.0f, false)) continue;
                pl.func_145747_a((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.tyrosaur.stomp", TextFormatting.DARK_GREEN));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.tyrosaur.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.TYROSAUR_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.TYROSAUR_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

