/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.mob.gardencia.BlueFlowerEntity;
import net.tslat.aoa3.entity.mob.gardencia.GreenFlowerEntity;
import net.tslat.aoa3.entity.mob.gardencia.OrangeFlowerEntity;
import net.tslat.aoa3.entity.mob.gardencia.PurpleFlowerEntity;
import net.tslat.aoa3.entity.mob.gardencia.YellowFlowerEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class VinocorneEntity
extends AoAMeleeMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private int minionCountdown = 70;

    public VinocorneEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.28125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 10.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_HURT.get();
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70089_S()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.minionCountdown > 0) {
                --this.minionCountdown;
            }
            if (this.minionCountdown == 0) {
                this.minionCountdown = 70;
                switch (this.field_70146_Z.nextInt(5)) {
                    case 0: {
                        this.field_70170_p.func_217376_c((Entity)new BlueFlowerEntity(this));
                        break;
                    }
                    case 1: {
                        this.field_70170_p.func_217376_c((Entity)new YellowFlowerEntity(this));
                        break;
                    }
                    case 2: {
                        this.field_70170_p.func_217376_c((Entity)new OrangeFlowerEntity(this));
                        break;
                    }
                    case 3: {
                        this.field_70170_p.func_217376_c((Entity)new GreenFlowerEntity(this));
                        break;
                    }
                    case 4: {
                        this.field_70170_p.func_217376_c((Entity)new PurpleFlowerEntity(this));
                    }
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            PlayerUtil.messageAllPlayersInRange((ITextComponent)LocaleUtil.getLocaleMessage("message.mob.vinocorne.kill", killer.func_145748_c_().func_150254_d()), this.field_70170_p, this.func_180425_c(), 50);
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.VINOCORNE_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.VINOCORNE_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

