/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.MusicPacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.boss.BlueGuardianEntity;
import net.tslat.aoa3.entity.boss.GreenGuardianEntity;
import net.tslat.aoa3.entity.boss.RedGuardianEntity;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.YellowGuardianShotEntity;
import net.tslat.aoa3.util.AdvancementUtil;

public class YellowGuardianEntity
extends AoARangedMob {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private RedGuardianEntity redGuardian;
    private GreenGuardianEntity greenGuardian;
    private BlueGuardianEntity blueGuardian;

    public YellowGuardianEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.875f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 15, 30, 32.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AoAMinion.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 750.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_GUARDIAN_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_GUARDIAN_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_GUARDIAN_SHOOT.get();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.checkGuardian((LivingEntity)this.blueGuardian) && this.checkGuardian((LivingEntity)this.greenGuardian) && this.checkGuardian((LivingEntity)this.redGuardian)) {
            return super.func_184647_J();
        }
        return null;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void setGreenGuardian(GreenGuardianEntity greenGuardian) {
        this.greenGuardian = greenGuardian;
    }

    public void setRedGuardian(RedGuardianEntity redGuardian) {
        this.redGuardian = redGuardian;
    }

    public void setBlueGuardian(BlueGuardianEntity blueGuardian) {
        this.blueGuardian = blueGuardian;
    }

    private boolean checkGuardian(LivingEntity guardian) {
        return guardian == null || !guardian.func_70089_S() || guardian.func_110143_aJ() == 0.0f;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            if (this.checkGuardian((LivingEntity)this.blueGuardian) && this.checkGuardian((LivingEntity)this.greenGuardian) && this.checkGuardian((LivingEntity)this.redGuardian)) {
                for (ServerPlayerEntity pl : this.field_70170_p.func_217357_a(ServerPlayerEntity.class, this.func_174813_aQ().func_186662_g(20.0))) {
                    AdvancementUtil.completeAdvancement(pl, new ResourceLocation("aoa3", "haven/guard_that"), "kill_four_guardians");
                }
            }
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (target instanceof AoARangedMob && !target.func_184222_aU()) {
            return;
        }
        super.doProjectileEntityImpact(projectile, target);
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new YellowGuardianShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        AoAPackets.messagePlayer(player, new MusicPacket(true, AoASounds.YELLOW_GUARDIAN_MUSIC.getId()));
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        AoAPackets.messagePlayer(player, new MusicPacket(false, AoASounds.YELLOW_GUARDIAN_MUSIC.getId()));
        this.bossInfo.func_186761_b(player);
    }
}

