/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.minion;

import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.skill.HunterUtil;

public abstract class AoAMinion
extends TameableEntity {
    private final int lifespan;
    private int animationTicks = 0;
    protected String currentAnimation = null;

    public AoAMinion(EntityType<? extends TameableEntity> entityType, World world) {
        super(entityType, world);
        this.lifespan = -1;
    }

    public AoAMinion(EntityType<? extends TameableEntity> entityType, World world, int tickLifespan) {
        super(entityType, world);
        this.lifespan = tickLifespan;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lifespan > 0 && this.field_70173_aa >= this.lifespan) {
            this.func_70106_y();
        }
        if (this.animationTicks >= 0) {
            ++this.animationTicks;
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 30.0f, this.lifespan == -1 ? 2.0f : 100.0f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        if (this.isHostile()) {
            if (this.getBaseMeleeDamage() >= 0.0) {
                this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
                this.field_70714_bg.func_75776_a(7, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
                this.field_70714_bg.func_75776_a(8, (Goal)new MoveTowardsTargetGoal((CreatureEntity)this, (double)0.8f, 16.0f));
            }
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, EntityUtil.Predicates.HOSTILE_MOB));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
            this.field_70715_bh.func_75776_a(4, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        }
    }

    public boolean func_213336_c(LivingEntity target) {
        return super.func_213336_c(target) && !(target instanceof AoAMinion);
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        LivingEntity owner;
        if (target != null && (owner = this.func_70902_q()) instanceof PlayerEntity && !HunterUtil.canAttackTarget(target, (Entity)owner, false)) {
            return;
        }
        super.func_70624_b(target);
    }

    public void func_70604_c(@Nullable LivingEntity target) {
        LivingEntity owner;
        if (target != null && (owner = this.func_70902_q()) instanceof PlayerEntity && !HunterUtil.canAttackTarget(target, (Entity)owner, false)) {
            return;
        }
        super.func_70604_c(target);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMoveSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        if (this.isHostile()) {
            this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getBaseMeleeDamage());
        }
    }

    protected double getBaseMoveSpeed() {
        return 0.25;
    }

    protected abstract double getBaseMaxHealth();

    protected double getBaseMeleeDamage() {
        return -1.0;
    }

    protected abstract boolean isHostile();

    @Nullable
    protected SoundEvent func_184639_G() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187655_bw : SoundEvents.field_187545_bE;
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        if (entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()))) {
            this.func_130011_c(entity);
            return true;
        }
        return false;
    }

    public boolean func_180431_b(DamageSource source) {
        return super.func_180431_b(source) || this.func_184753_b() != null && source.func_76346_g() != null && source.func_76346_g().func_110124_au().equals(this.func_184753_b());
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }
}

