/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.minion;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.util.EntityUtil;

public class MechaSkelloxEntity
extends AoAMinion {
    public MechaSkelloxEntity(EntityType<? extends TameableEntity> entityType, World world) {
        super(entityType, world);
        this.func_70659_e(3.2f);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.09375f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 30.0f, 2.0f, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        if (this.isHostile()) {
            if (this.getBaseMeleeDamage() >= 0.0) {
                this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
                this.field_70714_bg.func_75776_a(7, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
            }
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, EntityUtil.Predicates.HOSTILE_MOB));
            this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70715_bh.func_75776_a(3, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
            this.field_70715_bh.func_75776_a(4, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        }
    }

    @Override
    protected double getBaseMoveSpeed() {
        return 0.72;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 160.0;
    }

    @Override
    protected boolean isHostile() {
        return true;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_MECHYON_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_MECHYON_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_MECHYON_DEATH.get();
    }

    public void func_213352_e(Vec3d motionVec) {
        double travelledZ;
        if (this.func_70613_aW() || this.func_184186_bw()) {
            Vec3d currentMotion;
            boolean falling;
            IAttributeInstance gravity = this.func_110148_a(ENTITY_GRAVITY);
            boolean bl = falling = this.func_213322_ci().field_72448_b <= 0.0;
            if (falling && this.func_70644_a(Effects.field_204839_B)) {
                if (!gravity.func_180374_a(EntityUtil.SLOW_FALLING)) {
                    gravity.func_111121_a(EntityUtil.SLOW_FALLING);
                }
                this.field_70143_R = 0.0f;
            } else if (gravity.func_180374_a(EntityUtil.SLOW_FALLING)) {
                gravity.func_111124_b(EntityUtil.SLOW_FALLING);
            }
            double gravityValue = gravity.func_111126_e();
            if (!this.func_70090_H()) {
                if (!this.func_180799_ab()) {
                    BlockPos feetPos = this.func_226270_aj_();
                    float blockSlip = this.field_70170_p.func_180495_p(feetPos).getSlipperiness((IWorldReader)this.field_70170_p, feetPos, (Entity)this);
                    float friction = this.field_70122_E ? blockSlip * 0.91f : 0.91f;
                    float moveFactor = this.field_70122_E ? this.func_70689_ay() * (0.21600002f / (blockSlip * blockSlip * blockSlip)) : this.field_70747_aH;
                    friction = (float)((double)friction * 0.9);
                    this.func_213309_a(moveFactor, motionVec);
                    currentMotion = this.func_213322_ci();
                    if (this.func_70617_f_()) {
                        this.field_70143_R = 0.0f;
                        currentMotion = new Vec3d(MathHelper.func_151237_a((double)currentMotion.field_72450_a, (double)-0.15f, (double)0.15f), Math.max(currentMotion.field_72448_b, (double)-0.15f), MathHelper.func_151237_a((double)currentMotion.field_72449_c, (double)-0.15f, (double)0.15f));
                    }
                    this.func_213317_d(currentMotion);
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                    currentMotion = this.func_213322_ci();
                    if ((this.field_70123_F || this.field_70703_bu) && this.func_70617_f_()) {
                        currentMotion = new Vec3d(currentMotion.field_72450_a, 0.2, currentMotion.field_72449_c);
                    }
                    double yVelocity = currentMotion.field_72448_b;
                    if (this.func_70644_a(Effects.field_188424_y)) {
                        yVelocity += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - currentMotion.field_72448_b) * 0.2;
                        this.field_70143_R = 0.0f;
                    } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(feetPos)) {
                        yVelocity = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                    } else if (!this.func_189652_ae()) {
                        yVelocity -= gravityValue;
                    }
                    this.func_213293_j(currentMotion.field_72450_a * (double)friction, yVelocity * (double)0.98f, currentMotion.field_72449_c * (double)friction);
                } else {
                    this.func_213309_a(0.02f, motionVec);
                    this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                    if (!this.func_189652_ae()) {
                        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -gravityValue / 4.0, 0.0));
                    }
                    currentMotion = this.func_213322_ci();
                    if (this.field_70123_F && this.func_70038_c(currentMotion.field_72450_a, currentMotion.field_72448_b + (double)0.6f - this.func_226278_cu_() + this.func_226278_cu_(), currentMotion.field_72449_c)) {
                        this.func_213293_j(currentMotion.field_72450_a, 0.3f, currentMotion.field_72449_c);
                    }
                }
            } else {
                float drag = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float swimSpeed = 0.02f;
                float depthStrider = EnchantmentHelper.func_185294_d((LivingEntity)this);
                if (depthStrider > 3.0f) {
                    depthStrider = 3.0f;
                }
                if (!this.field_70122_E) {
                    depthStrider *= 0.5f;
                }
                if (depthStrider > 0.0f) {
                    drag += (0.54600006f - drag) * depthStrider / 3.0f;
                    swimSpeed += (this.func_70689_ay() - swimSpeed) * depthStrider / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    drag = 0.96f;
                }
                this.func_213309_a(swimSpeed *= (float)this.func_110148_a(SWIM_SPEED).func_111126_e(), motionVec);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                currentMotion = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    currentMotion = new Vec3d(currentMotion.field_72450_a, 0.2, currentMotion.field_72449_c);
                }
                this.func_213317_d(currentMotion.func_216372_d((double)drag, (double)0.8f, (double)drag));
                if (!this.func_189652_ae() && !this.func_70051_ag()) {
                    currentMotion = this.func_213322_ci();
                    double motionY = falling && Math.abs(currentMotion.field_72448_b - 0.005) >= 0.003 && Math.abs(currentMotion.field_72448_b - gravityValue / 16.0) < 0.003 ? -0.003 : currentMotion.field_72448_b - gravityValue / 16.0;
                    this.func_213293_j(currentMotion.field_72450_a, motionY, currentMotion.field_72449_c);
                }
                currentMotion = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(currentMotion.field_72450_a, currentMotion.field_72448_b + (double)0.6f - this.func_226278_cu_() + this.func_226278_cu_(), currentMotion.field_72449_c)) {
                    this.func_213293_j(currentMotion.field_72450_a, 0.3f, currentMotion.field_72449_c);
                }
            }
        }
        this.field_184618_aE = this.field_70721_aZ;
        double travelledX = this.func_226277_ct_() - this.field_70169_q;
        float travel = MathHelper.func_76133_a((double)(travelledX * travelledX + (travelledZ = this.func_226281_cx_() - this.field_70166_s) * travelledZ)) * 4.0f;
        if (travel > 1.0f) {
            travel = 1.0f;
        }
        this.field_70721_aZ += (travel - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }
}

