/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.misc;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;
import net.tslat.aoa3.util.skill.AnimaUtil;

public class AnimaStoneEntity
extends Entity {
    public AnimaStoneEntity(EntityType<? extends Entity> entityType, World world) {
        super(entityType, world);
        this.func_174810_b(true);
    }

    public AnimaStoneEntity(World world, BlockPos spawnPosition) {
        this((EntityType<? extends Entity>)((EntityType)AoAEntities.Misc.ANIMA_STONE.get()), world);
        this.func_70634_a(spawnPosition.func_177958_n(), spawnPosition.func_177956_o(), spawnPosition.func_177952_p());
    }

    protected float func_213316_a(Pose pose, EntitySize size) {
        return 0.25f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= 200) {
            this.func_70106_y();
            return;
        }
        boolean isFalling = this.func_213322_ci().field_72448_b <= 0.0;
        double gravity = 0.08;
        if (!this.func_70090_H()) {
            BlockPos groundPos = this.func_226270_aj_();
            float slipperiness = this.field_70170_p.func_180495_p(groundPos).getSlipperiness((IWorldReader)this.field_70170_p, groundPos, (Entity)this);
            float friction = this.field_70122_E ? slipperiness * 0.91f : 0.91f;
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            Vec3d motion = this.func_213322_ci();
            double motionY = motion.field_72448_b;
            if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(groundPos)) {
                motionY = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
            } else if (!this.func_189652_ae()) {
                motionY -= gravity;
            }
            this.func_213293_j(motion.field_72450_a * (double)friction, motionY * (double)0.98f, motion.field_72449_c * (double)friction);
        } else {
            double initialPosY = this.func_226278_cu_();
            float waterDrag = 0.8f;
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            Vec3d motion = this.func_213322_ci();
            this.func_213317_d(motion.func_216372_d((double)waterDrag, (double)0.8f, (double)waterDrag));
            if (!this.func_189652_ae()) {
                motion = this.func_213322_ci();
                double motionY = isFalling && Math.abs(motion.field_72448_b - 0.005) >= 0.003 && Math.abs(motion.field_72448_b - gravity / 16.0) < 0.003 ? -0.003 : motion.field_72448_b - gravity / 16.0;
                this.func_213293_j(motion.field_72450_a, motionY, motion.field_72449_c);
            }
            motion = this.func_213322_ci();
            if (this.field_70123_F && this.func_70038_c(motion.field_72450_a, motion.field_72448_b + 0.6 - this.func_226278_cu_() + initialPosY, motion.field_72449_c)) {
                this.func_213293_j(motion.field_72450_a, 0.3f, motion.field_72449_c);
            }
        }
    }

    public void func_70100_b_(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity && this.func_70089_S()) {
            PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
            int lvl = plData.stats().getLevel(Skills.ANIMA);
            plData.stats().addXp(Skills.ANIMA, PlayerUtil.getXpRequiredForNextLevel(lvl / AnimaUtil.getExpDenominator(lvl)), false, false);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.HEART_STONE_COLLECT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.func_70106_y();
            if (this.field_70146_Z.nextInt(3) == 0) {
                ItemUtil.givePlayerItemOrDrop(player, new ItemStack((IItemProvider)AoAItems.FRAGMENTED_ANIMA_STONE.get(), 1));
            }
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
    }
}

