/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.misc;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.boss.BaronessEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.WorldUtil;

public class BaronBombEntity
extends Entity {
    private int timer = 150;
    private UUID ownerUUID = null;
    private PlayerEntity ownerPlayer = null;
    private BaronessEntity baroness = null;

    public BaronBombEntity(EntityType<? extends Entity> entityType, World world) {
        super(entityType, world);
    }

    public BaronBombEntity(PlayerEntity pl) {
        this((EntityType<? extends Entity>)((EntityType)AoAEntities.Misc.BARON_BOMB.get()), pl.field_70170_p);
        this.ownerUUID = pl.func_110124_au();
        this.func_70634_a(pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_());
    }

    public BaronBombEntity(BaronessEntity baroness) {
        this((EntityType<? extends Entity>)((EntityType)AoAEntities.Misc.BARON_BOMB.get()), baroness.field_70170_p);
        this.baroness = baroness;
        this.func_70634_a(baroness.func_226277_ct_(), baroness.func_226278_cu_(), baroness.func_226281_cx_());
    }

    protected float func_213316_a(Pose pose, EntitySize size) {
        return 0.25f;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public boolean func_70104_M() {
        return this.func_70089_S();
    }

    protected void func_70088_a() {
    }

    public void func_70100_b_(PlayerEntity entity) {
        if (!this.field_70170_p.field_72995_K && this.checkEntityCollision((Entity)entity)) {
            if (this.ownerUUID == null) {
                WorldUtil.createExplosion((Entity)this.baroness, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 3.5f, WorldUtil.checkGameRule(this.field_70170_p, AoAGameRules.STRONGER_MOB_GRIEFING) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE, false);
            } else {
                WorldUtil.createExplosion((Entity)this.ownerPlayer, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 2.0f);
            }
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public void func_70108_f(Entity entity) {
        if (!this.field_70170_p.field_72995_K && this.checkEntityCollision(entity)) {
            if (this.ownerPlayer != null) {
                WorldUtil.createExplosion((Entity)this.ownerPlayer, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 2.0f);
            } else {
                WorldUtil.createExplosion((Entity)this.baroness, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 3.5f, WorldUtil.checkGameRule(this.field_70170_p, AoAGameRules.STRONGER_MOB_GRIEFING) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE, false);
            }
            this.func_70106_y();
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            if (!source.func_94541_c() && source.func_76346_g() != this.baroness && source.func_76346_g() != this.ownerPlayer) {
                if (this.ownerPlayer != null) {
                    WorldUtil.createExplosion((Entity)this.ownerPlayer, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 2.0f);
                } else {
                    WorldUtil.createExplosion((Entity)this.baroness, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 3.5f, WorldUtil.checkGameRule(this.field_70170_p, AoAGameRules.STRONGER_MOB_GRIEFING) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE, false);
                }
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_85031_j(Entity attacker) {
        if (!this.field_70170_p.field_72995_K && this.checkEntityCollision(attacker)) {
            this.func_70106_y();
        }
        return true;
    }

    private boolean checkEntityCollision(Entity target) {
        UUID ownerUUID;
        if (this.ownerUUID == null) {
            return !(target instanceof BaronessEntity);
        }
        if (target instanceof PlayerEntity) {
            this.updateOwner();
            if (this.ownerPlayer != null && !EntityUtil.canPvp(this.ownerPlayer, (PlayerEntity)target)) {
                return false;
            }
        } else if (target instanceof TameableEntity && (ownerUUID = ((TameableEntity)target).func_184753_b()) != null && ownerUUID.equals(this.ownerUUID)) {
            return false;
        }
        return true;
    }

    private void updateOwner() {
        this.ownerPlayer = this.ownerPlayer == null ? this.field_70170_p.func_73046_m().func_184103_al().func_177451_a(this.ownerUUID) : this.ownerPlayer;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        BlockPos pos = new BlockPos(this.func_226277_ct_(), 0.0, this.func_226281_cx_());
        Vec3d motion = this.func_213322_ci();
        double motionX = motion.func_82615_a();
        double motionY = motion.func_82617_b();
        double motionZ = motion.func_82616_c();
        if (!this.field_70170_p.field_72995_K || this.field_70170_p.func_175667_e(pos) && this.field_70170_p.isAreaLoaded(pos, 1)) {
            if (!this.func_189652_ae()) {
                motionY -= 0.08;
            }
        } else {
            motionY = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
        }
        motionX = 0.0;
        motionZ = 0.0;
        this.func_213315_a(MoverType.SELF, new Vec3d(motionX, motionY, motionZ));
        if (!this.field_70170_p.field_72995_K) {
            if (this.ownerUUID == null && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                this.func_70106_y();
                return;
            }
            --this.timer;
            if (this.timer == 16) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.BARON_BOMB_PRIME.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            } else if (this.timer <= 0) {
                this.updateOwner();
                if (this.ownerPlayer != null) {
                    WorldUtil.createExplosion((Entity)this.ownerPlayer, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 2.0f);
                } else {
                    WorldUtil.createExplosion((Entity)this.baroness, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 4.0f);
                }
                this.func_70106_y();
            }
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

