/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.misc;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.stats.Stats;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.item.misc.summoning.BossSpawningItem;

public class BossItemEntity
extends ItemEntity {
    public static final int lifetime = 200;
    private final PlayerEntity player;

    public BossItemEntity(World world, double x, double y, double z, ItemStack stack, PlayerEntity player) {
        super((EntityType)AoAEntities.Misc.BOSS_ITEM.get(), world);
        this.lifespan = 200;
        this.player = player;
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
        this.func_70107_b(x, y, z);
        this.func_92058_a(stack);
        this.func_213293_j(this.field_70146_Z.nextDouble() * 0.2 - 0.1, 0.2, this.field_70146_Z.nextDouble() * 0.2 - 0.1);
    }

    public BossItemEntity(EntityType<? extends ItemEntity> entityType, World world) {
        super(entityType, world);
        this.lifespan = 200;
        this.player = null;
    }

    public void func_70100_b_(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K && !this.func_174874_s() && player.func_110124_au().equals(this.func_200215_l())) {
            ItemStack stack = this.func_92059_d();
            int stackSize = stack.func_190916_E();
            int hookResult = ForgeEventFactory.onItemPickup((ItemEntity)this, (PlayerEntity)player);
            if (hookResult < 0) {
                return;
            }
            ItemStack stackCopy = stack.func_77946_l();
            if (hookResult == 1 || stackSize <= 0 || player.field_71071_by.func_70441_a(stack) || stackCopy.func_190916_E() > this.func_92059_d().func_190916_E()) {
                stackCopy.func_190920_e(stackCopy.func_190916_E() - this.func_92059_d().func_190916_E());
                BasicEventHooks.firePlayerItemPickupEvent((PlayerEntity)player, (ItemEntity)this, (ItemStack)stackCopy);
                if (stack.func_190926_b()) {
                    player.func_71001_a((Entity)this, stackSize);
                    this.func_70106_y();
                    stack.func_190920_e(stackSize);
                }
                player.func_71064_a(Stats.field_75929_E.func_199076_b((Object)this.func_92059_d().func_77973_b()), stackSize);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lifespan == 6000) {
            return;
        }
        if (!(this.field_70170_p.field_72995_K || this.player != null && this.func_92059_d().func_77973_b() instanceof BossSpawningItem)) {
            this.func_70106_y();
            return;
        }
        BossSpawningItem bossItem = (BossSpawningItem)this.func_92059_d().func_77973_b();
        if (this.player instanceof ServerPlayerEntity) {
            if (this.field_70173_aa == this.lifespan - 1) {
                if (bossItem.canSpawnHere(this.field_70170_p, (ServerPlayerEntity)this.player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_())) {
                    bossItem.spawnBoss(this.field_70170_p, (ServerPlayerEntity)this.player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                    this.func_70106_y();
                } else {
                    this.lifespan = 6000;
                }
            }
            return;
        }
        if (this.field_70173_aa < this.lifespan) {
            bossItem.handleTimerParticles(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.lifespan, this.field_70173_aa);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

