/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.misc;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LootUtil;

public class LottoTotemEntity
extends Entity {
    private UUID winnerUUID = null;
    private UUID ownerUUID = null;

    public LottoTotemEntity(World world, BlockPos pos, UUID winnerUUID, UUID ownerUUID) {
        this((EntityType<? extends Entity>)((EntityType)AoAEntities.Misc.LOTTO_TOTEM.get()), world);
        this.winnerUUID = winnerUUID;
        this.ownerUUID = ownerUUID;
        VoxelShape floorShape = world.func_180495_p(pos).func_196954_c((IBlockReader)world, pos);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + floorShape.func_197758_c(Direction.Axis.Y), (double)pos.func_177952_p() + 0.5);
    }

    public LottoTotemEntity(EntityType<? extends Entity> entityType, World world) {
        super(entityType, world);
        this.field_70156_m = true;
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        return this.field_70173_aa >= 12000 || !this.field_70170_p.field_72995_K && (this.ownerUUID == null || player.func_110124_au().equals(this.ownerUUID));
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (this.func_70089_S() && (this.ownerUUID == null || player.func_110124_au().equals(this.ownerUUID))) {
            if (player instanceof ServerPlayerEntity) {
                if (this.winnerUUID != null && this.winnerUUID.equals(this.func_110124_au())) {
                    for (ItemStack stack : LootUtil.generateLoot((ServerWorld)this.field_70170_p, new ResourceLocation("aoa3", "misc/lotto_totem"), LootUtil.getGiftContext((ServerWorld)this.field_70170_p, this.func_180425_c(), 5.0f, (Entity)player))) {
                        ItemEntity drop = this.func_70099_a(stack, 0.0f);
                        if (drop != null) {
                            drop.func_200217_b(player.func_110124_au());
                        }
                        AdvancementUtil.completeAdvancement((ServerPlayerEntity)player, new ResourceLocation("aoa3", "overworld/winner_winner"), "lotto_win");
                    }
                    ItemEntity drop = this.func_70099_a(new ItemStack((IItemProvider)AoABlocks.LOTTO_BANNER.get()), 0.0f);
                    if (drop != null) {
                        drop.func_200217_b(player.func_110124_au());
                    }
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), (SoundEvent)AoASounds.LOTTO_WIN.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                for (LottoTotemEntity totem : this.field_70170_p.func_217357_a(LottoTotemEntity.class, new AxisAlignedBB(this.func_180425_c()).func_186662_g(2.0))) {
                    totem.func_70106_y();
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.field_70170_p.field_72995_K && !this.func_70089_S()) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.func_226277_ct_(), this.func_226278_cu_() + 0.3, this.func_226281_cx_(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected void func_70088_a() {
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (compound.func_186855_b("WinningUUID")) {
            this.winnerUUID = compound.func_186857_a("WinningUUID");
        }
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerUUID = compound.func_186857_a("OwnerUUID");
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (this.winnerUUID != null) {
            compound.func_186854_a("WinningUUID", this.winnerUUID);
        }
        if (this.ownerUUID != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    public void func_70071_h_() {
        this.func_70030_z();
    }

    public void func_70030_z() {
        this.field_70170_p.func_217381_Z().func_76320_a("entityBaseTick");
        if (this.func_226278_cu_() < -64.0) {
            this.func_70076_C();
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }
}

