/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.misc.pixon;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.tool.misc.InfusionBowl;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class PixonEntity
extends CreatureEntity {
    public long nextHarvestTick = 0L;

    public PixonEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 0.75));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.55));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(15 + this.field_70146_Z.nextInt(30)));
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.40000000298023225);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        return false;
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public int func_70641_bl() {
        return 1;
    }

    public boolean canHarvest(ServerPlayerEntity player, ItemStack bowlStack) {
        if (this.field_70170_p.func_82737_E() >= this.nextHarvestTick && bowlStack.func_77973_b() instanceof InfusionBowl) {
            InfusionBowl bowl = (InfusionBowl)bowlStack.func_77973_b();
            if (player.func_184812_l_() || PlayerUtil.doesPlayerHaveLevel(player, Skills.INFUSION, this.getHarvestLevelReq() + bowl.getHarvestReqModifier())) {
                return true;
            }
            PlayerUtil.notifyPlayerOfInsufficientLevel(player, Skills.INFUSION, this.getHarvestLevelReq() + bowl.getHarvestReqModifier());
        }
        return false;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        if (!EntityUtil.isNaturalSpawnReason(reason)) {
            return true;
        }
        return world.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == world.func_226691_t_((BlockPos)this.func_180425_c()).func_205401_q().field_215454_b.func_204108_a().func_177230_c();
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 0.65f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_PIXON_AMBIENT.get();
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return null;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
    }

    public abstract int getHarvestLevelReq();
}

