/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.abyss;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerUtil;

public class BloodsuckerEntity
extends AoAMeleeMob {
    public BloodsuckerEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.85f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 109.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 8.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.295;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_BLOODSUCKER_AMBIENT.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_BLOODSUCKER_DEATH.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_BLOODSUCKER_HURT.get();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    @Override
    protected void onAttack(Entity target) {
        EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 80).level(3));
        this.func_70691_i((float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 2.0f);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.ANCIENT_CAVERN.type()) {
            Entity source = cause.func_76346_g();
            ServerPlayerEntity killer = null;
            if (source != null) {
                if (source instanceof ServerPlayerEntity) {
                    killer = (ServerPlayerEntity)source;
                } else if (source instanceof TameableEntity && ((TameableEntity)source).func_70902_q() instanceof ServerPlayerEntity) {
                    killer = (ServerPlayerEntity)((TameableEntity)source).func_70902_q();
                }
            }
            if (killer != null) {
                PlayerUtil.addTributeToPlayer(killer, Deities.EREBON, 8);
            }
        }
    }
}

