/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.abyss;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.MagicBallEntity;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;

public class WebReaperEntity
extends AoARangedMob {
    private static final DataParameter<Integer> STAGE = EntityDataManager.func_187226_a(WebReaperEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final AttributeModifier STAGE_HEALTH_MOD = new AttributeModifier(UUID.fromString("9c59eceb-dcd0-40e0-a608-a46d3794b1c3"), "StageHealthModifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL){

        public double func_111164_d() {
            return Math.max(0.0f, WebReaperEntity.this.stageMod - 1.0f);
        }
    };
    private final AttributeModifier STAGE_KNOCKBACK_MOD = new AttributeModifier(UUID.fromString("a7cd0b89-ca94-4e54-a0c4-f56e8cb70bb0"), "StageKnockbackModifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL){

        public double func_111164_d() {
            return Math.max(0.0, (double)(WebReaperEntity.this.stageMod - 1.0f) * 0.83);
        }
    };
    private int stage;
    private float stageMod;
    private boolean shouldHeal = false;

    public WebReaperEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, SharedMonsterAttributes.field_111267_a, this.STAGE_HEALTH_MOD);
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, SharedMonsterAttributes.field_111266_c, this.STAGE_KNOCKBACK_MOD);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.stage = 1;
        this.stageMod = 1.0f;
        this.field_70180_af.func_187214_a(STAGE, (Object)1);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.375f * this.stageMod;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.6;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 107.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 13.0f * this.stageMod;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_WEB_REAPER_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_WEB_REAPER_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_WEB_REAPER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_WEB_REAPER_SHOOT.get();
    }

    public int getStage() {
        return this.stage;
    }

    public float getStageMod() {
        return this.stageMod;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == AoAItems.NIGHTMARE_FLAKES.get()) {
            if (this.stage >= 10) {
                return false;
            }
            if (!this.field_70170_p.field_72995_K) {
                heldStack.func_190918_g(1);
                ++this.stage;
                this.updateStage();
                this.shouldHeal = true;
            }
            return true;
        }
        if (heldStack.func_77973_b() == Items.field_151134_bR && this.stage > 1) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_184611_a(hand, new ItemStack((IItemProvider)AoAItems.BOOK_OF_SHADOWS.get()));
                if (this.stage <= 10) {
                    this.stage += 5;
                    this.updateStage();
                    this.shouldHeal = true;
                }
            }
            return true;
        }
        return false;
    }

    private void updateStage() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(STAGE, (Object)this.stage);
        } else {
            this.stage = (Integer)this.field_70180_af.func_187225_a(STAGE);
        }
        this.stageMod = 1.0f + (float)(this.stage - 1) / 7.5f;
        if (!this.field_70170_p.field_72995_K) {
            EntityUtil.reapplyAttributeModifier((LivingEntity)this, SharedMonsterAttributes.field_111267_a, this.STAGE_HEALTH_MOD);
            EntityUtil.reapplyAttributeModifier((LivingEntity)this, SharedMonsterAttributes.field_111266_c, this.STAGE_KNOCKBACK_MOD);
        }
        this.func_213323_x_();
        this.field_70728_aV = (int)this.func_110138_aP() / 10 + (int)(((double)this.func_110138_aP() - this.getBaseMaxHealth()) * (double)0.1f);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.func_200600_R().func_220334_j().func_220313_a(this.stageMod);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == STAGE) {
            this.updateStage();
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("WebReaperStage")) {
            this.stage = compound.func_74762_e("WebReaperStage");
            this.updateStage();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.stage > 1) {
            compound.func_74768_a("WebReaperStage", this.stage);
        }
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new MagicBallEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (this.stage >= 15) {
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 100).level(2));
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof ServerPlayerEntity && this.stage >= 15) {
            AdvancementUtil.completeAdvancement((ServerPlayerEntity)cause.func_76346_g(), new ResourceLocation("aoa3", "abyss/reaper_reaper"), "nightmare_web_reaper_kill");
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.shouldHeal) {
            this.func_70606_j(this.func_110138_aP());
            this.shouldHeal = false;
        }
    }

    public ITextComponent func_200200_C_() {
        String stagePrefix;
        if (this.func_145818_k_()) {
            return this.func_200201_e();
        }
        String baseName = this.func_200600_R().getRegistryName().func_110623_a();
        String string = this.stage >= 15 ? "nightmare" : (stagePrefix = this.stage >= 5 ? "empowered" : null);
        if (stagePrefix != null) {
            return LocaleUtil.getLocaleMessage("entity.aoa3." + stagePrefix + "_" + baseName);
        }
        return LocaleUtil.getLocaleMessage("entity.aoa3." + baseName);
    }
}

