/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.creeponia;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public abstract class AoACreeponiaCreeper
extends AoAMeleeMob {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(AoACreeponiaCreeper.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(AoACreeponiaCreeper.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(AoACreeponiaCreeper.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected int fuseTime = 30;
    protected int lastActiveTime;
    protected int timeSinceIgnited;
    private float swimAnimation;
    private float lastSwimAnimation;
    private int explosionRadius = 3;

    public AoACreeponiaCreeper(EntityType<? extends AoACreeponiaCreeper> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = (int)(this.getBaseMaxHealth() / 10.0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new CustomCreeperSwellGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, OcelotEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, CatEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TameableEntity.class, 10, true, false, entity -> entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n()));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth() * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 2.0f : 1.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    @Override
    protected abstract double getBaseKnockbackResistance();

    @Override
    protected abstract double getBaseMaxHealth();

    @Override
    protected abstract double getBaseMovementSpeed();

    public abstract float getExplosionStrength();

    @Override
    protected int getMaxSpawnHeight() {
        return -1;
    }

    @Override
    protected void onAttack(Entity target) {
    }

    @Override
    protected void onHit(DamageSource source, float amount) {
    }

    public static boolean meetsSpawnConditions(EntityType<? extends MonsterEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    @Override
    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    @Override
    protected boolean canSpawnAt(SpawnReason reason, BlockState blockState) {
        if (this.getMaxSpawnHeight() >= 0 && this.func_226278_cu_() > (double)this.getMaxSpawnHeight()) {
            return false;
        }
        return blockState.func_215688_a((IBlockReader)this.field_70170_p, this.func_180425_c(), this.func_200600_R());
    }

    private boolean isValidLightLevel(SpawnReason reason) {
        return WorldUtil.getLightLevel(this.field_70170_p, this.func_180425_c(), true, false) <= RandomUtil.randomNumberUpTo(8);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187570_aq;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    @Override
    protected void func_180429_a(BlockPos pos, BlockState block) {
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(LightningBoltEntity lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                itemstack.func_222118_a(1, (LivingEntity)player, p_213625_1_ -> p_213625_1_.func_213334_d(hand));
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int creeperState;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((creeperState = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += creeperState;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        if (!ForgeHooks.onLivingUpdate((LivingEntity)this)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70052_a(6, this.func_225510_bt_());
            }
            this.func_70030_z();
            this.lastSwimAnimation = this.swimAnimation;
            this.swimAnimation = this.func_213314_bj() ? Math.min(1.0f, this.swimAnimation + 0.09f) : Math.max(0.0f, this.swimAnimation - 0.09f);
            if (!this.field_70170_p.field_72995_K) {
                int beeStings;
                int arrowCount = this.func_85035_bI();
                if (arrowCount > 0) {
                    if (this.field_70720_be <= 0) {
                        this.field_70720_be = 20 * (30 - arrowCount);
                    }
                    --this.field_70720_be;
                    if (this.field_70720_be <= 0) {
                        this.func_85034_r(arrowCount - 1);
                    }
                }
                if ((beeStings = this.func_226297_df_()) > 0) {
                    if (this.field_226290_au_ <= 0) {
                        this.field_226290_au_ = 20 * (30 - beeStings);
                    }
                    --this.field_226290_au_;
                    if (this.field_226290_au_ <= 0) {
                        this.func_226300_q_(beeStings - 1);
                    }
                }
                if (this.field_70173_aa % 20 == 0) {
                    this.func_110142_aN().func_94549_h();
                }
                if (!this.field_184238_ar) {
                    boolean glowing = this.func_70644_a(Effects.field_188423_x);
                    if (this.func_70083_f(6) != glowing) {
                        this.func_70052_a(6, glowing);
                    }
                }
            }
            this.func_70636_d();
            double diffX = this.func_226277_ct_() - this.field_70169_q;
            double diffZ = this.func_226281_cx_() - this.field_70166_s;
            float movementDiff = (float)(diffX * diffX + diffZ * diffZ);
            float direction = this.field_70761_aq;
            float distanceMoved = 0.0f;
            this.field_70768_au = this.field_110154_aX;
            float moveSpeedBase = 0.0f;
            if (movementDiff > 0.0025000002f) {
                moveSpeedBase = 1.0f;
                distanceMoved = (float)Math.sqrt(movementDiff) * 3.0f;
                float f = (float)MathHelper.func_181159_b((double)diffZ, (double)diffX) * 57.295776f - 90.0f;
                float f1 = MathHelper.func_76135_e((float)(MathHelper.func_76142_g((float)this.field_70177_z) - f));
                direction = 95.0f < f1 && f1 < 265.0f ? f - 180.0f : f;
            }
            if (this.field_70733_aJ > 0.0f) {
                direction = this.field_70177_z;
            }
            if (!this.field_70122_E) {
                moveSpeedBase = 0.0f;
            }
            this.field_110154_aX += (moveSpeedBase - this.field_110154_aX) * 0.3f;
            this.field_70170_p.func_217381_Z().func_76320_a("headTurn");
            distanceMoved = this.func_110146_f(direction, distanceMoved);
            this.field_70170_p.func_217381_Z().func_76319_b();
            this.field_70170_p.func_217381_Z().func_76320_a("rangeChecks");
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            while (this.field_70761_aq - this.field_70760_ar < -180.0f) {
                this.field_70760_ar -= 360.0f;
            }
            while (this.field_70761_aq - this.field_70760_ar >= 180.0f) {
                this.field_70760_ar += 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70759_as - this.field_70758_at < -180.0f) {
                this.field_70758_at -= 360.0f;
            }
            while (this.field_70759_as - this.field_70758_at >= 180.0f) {
                this.field_70758_at += 360.0f;
            }
            this.field_70170_p.func_217381_Z().func_76319_b();
            this.field_70764_aw += distanceMoved;
            this.field_184629_bo = this.func_184613_cA() ? ++this.field_184629_bo : 0;
            if (this.func_70608_bn()) {
                this.field_70125_A = 0.0f;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_110159_bB();
            if (this.field_70173_aa % 5 == 0) {
                this.func_213385_F();
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        boolean success = super.func_225503_b_(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return success;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_205015_b(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastSwimAnimation, (float)this.swimAnimation);
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    protected void explode() {
        if (!this.field_70170_p.field_72995_K) {
            WorldUtil.createExplosion((Entity)this, this.field_70170_p, this.getExplosionStrength() * (this.isCharged() ? 2.0f : 1.0f));
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    protected void spawnLingeringCloud() {
        Collection activeEffects = this.func_70651_bq();
        if (!activeEffects.isEmpty()) {
            AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            cloud.func_184483_a(2.5f);
            cloud.func_184495_b(-0.5f);
            cloud.func_184485_d(10);
            cloud.func_184486_b(cloud.func_184489_o() / 2);
            cloud.func_184487_c(-cloud.func_184490_j() / (float)cloud.func_184489_o());
            for (EffectInstance effect : activeEffects) {
                cloud.func_184496_a(new EffectInstance(effect));
            }
            this.field_70170_p.func_217376_c((Entity)cloud);
        }
    }

    public class CustomCreeperSwellGoal
    extends Goal {
        private final AoACreeponiaCreeper swellingCreeper;
        private LivingEntity target;

        public CustomCreeperSwellGoal(AoACreeponiaCreeper entity) {
            this.swellingCreeper = entity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            LivingEntity target = this.swellingCreeper.func_70638_az();
            return this.swellingCreeper.getCreeperState() > 0 || target != null && this.swellingCreeper.func_70068_e((Entity)target) < 9.0;
        }

        public void func_75249_e() {
            this.swellingCreeper.func_70661_as().func_75499_g();
            this.target = this.swellingCreeper.func_70638_az();
        }

        public void func_75251_c() {
            this.target = null;
        }

        public void func_75246_d() {
            if (this.target == null) {
                this.swellingCreeper.setCreeperState(-1);
            } else if (this.swellingCreeper.func_70068_e((Entity)this.target) > 49.0) {
                this.swellingCreeper.setCreeperState(-1);
            } else if (!this.swellingCreeper.func_70635_at().func_75522_a((Entity)this.target)) {
                this.swellingCreeper.setCreeperState(-1);
            } else {
                this.swellingCreeper.setCreeperState(1);
            }
        }
    }
}

