/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.creeponia;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.mob.creeponia.AoACreeponiaCreeper;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.CreeperShotEntity;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class CreeperlockEntity
extends AoACreeponiaCreeper
implements AoARangedAttacker {
    public CreeperlockEntity(EntityType<? extends AoACreeponiaCreeper> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.40625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 50.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    public float getExplosionStrength() {
        return 4.0f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_AMBIENT.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_DEATH.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CREEPOID_HURT.get();
    }

    @Override
    protected int getMaxSpawnHeight() {
        return 50;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70089_S()) {
            return;
        }
        PlayerEntity target = this.field_70170_p.func_217366_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 20.0, false);
        if (target == null || target.func_184812_l_()) {
            return;
        }
        if (!this.field_70170_p.field_72995_K && RandomUtil.oneInNChance(120)) {
            this.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_CREEPERLOCK_TELEPORT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        if (RandomUtil.oneInNChance(70)) {
            CreeperShotEntity projectile = new CreeperShotEntity(this, BaseMobProjectile.Type.MAGIC);
            double distanceFactorX = target.func_226277_ct_() - this.func_226277_ct_();
            double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - projectile.func_226278_cu_();
            double distanceFactorZ = target.func_226281_cx_() - this.func_226281_cx_();
            double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)AoASounds.ENTITY_MAGICAL_CREEPER_SHOOT.get(), SoundCategory.HOSTILE, 1.0f, 1.0f);
            projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
            this.field_70170_p.func_217376_c((Entity)projectile);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (DamageUtil.dealBlasterDamage((LivingEntity)this, target, (Entity)projectile, 7.0f, false)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }
}

