/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.deeplands;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.ClimberPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerUtil;

public class RockCritterEntity
extends AoAMeleeMob {
    private static final DataParameter<Byte> CLIMBING = EntityDataManager.func_187226_a(RockCritterEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public RockCritterEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)0);
    }

    protected PathNavigator func_175447_b(World world) {
        return new ClimberPathNavigator((MobEntity)this, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.8125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 75.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 7.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CAVE_BUG_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CAVE_BUG_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CAVE_BUG_HURT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return SoundEvents.field_187823_fN;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    @Override
    protected int getMaxSpawnHeight() {
        return 120;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return ((Byte)this.field_70180_af.func_187225_a(CLIMBING) & 1) != 0;
    }

    public void setBesideClimbableBlock(boolean climbing) {
        byte climbingBit = (Byte)this.field_70180_af.func_187225_a(CLIMBING);
        climbingBit = climbing ? (byte)(climbingBit | 1) : (byte)(climbingBit & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbingBit);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.ANCIENT_CAVERN.type()) {
            Entity source = cause.func_76346_g();
            ServerPlayerEntity killer = null;
            if (source != null) {
                if (source instanceof ServerPlayerEntity) {
                    killer = (ServerPlayerEntity)source;
                } else if (source instanceof TameableEntity && ((TameableEntity)source).func_70902_q() instanceof ServerPlayerEntity) {
                    killer = (ServerPlayerEntity)((TameableEntity)source).func_70902_q();
                }
            }
            if (killer != null) {
                PlayerUtil.addTributeToPlayer(killer, Deities.PLUTON, 8);
            }
        }
    }
}

