/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.gardencia;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;

public class SquasherEntity
extends AoAMeleeMob {
    private static final AttributeModifier CANDIED_WATER_BUFF = new AttributeModifier(UUID.fromString("d5356e33-40b6-4515-a37b-4377f911f703"), "AoAGardenciaCandiedWaterBuff", 50.0, AttributeModifier.Operation.ADDITION);
    private boolean candiedWater = false;

    public SquasherEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.15;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 105.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 9.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_PLANT_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_PLANT_HURT.get();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected float func_175134_bD() {
        return 0.8f;
    }

    protected void func_191955_a(BlockState state) {
        if (state.func_177230_c() == AoABlocks.CANDIED_WATER.get() && !this.candiedWater) {
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, SharedMonsterAttributes.field_111267_a, CANDIED_WATER_BUFF);
            this.func_70606_j(this.func_110143_aJ() * 1.5f);
            this.candiedWater = true;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.candiedWater) {
            compound.func_74757_a("AoACandiedWater", true);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.candiedWater = compound.func_74764_b("AoACandiedWater");
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S()) {
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                if (this.func_70090_H()) {
                    this.func_70691_i(0.2f);
                } else if (this.field_70170_p.func_175727_C(this.func_180425_c())) {
                    this.func_70691_i(0.1f);
                }
            }
            if (!this.field_70170_p.field_72995_K && RandomUtil.oneInNChance(250) && this.func_70643_av() != null) {
                this.func_70664_aZ();
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.candiedWater && cause.func_76346_g() instanceof PlayerEntity && ItemUtil.findInventoryItem((PlayerEntity)cause.func_76346_g(), new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
            ItemUtil.givePlayerItemOrDrop((PlayerEntity)cause.func_76346_g(), new ItemStack((IItemProvider)AoAItems.LBOREAN_REALMSTONE.get()));
        }
    }
}

