/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.haven;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerUtil;

public class AngelicaEntity
extends AoAFlyingMeleeMob {
    public AngelicaEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 84.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 1.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_ANGELICA_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_ANGELICA_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_ANGELICA_HURT.get();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.ANCIENT_CAVERN.type() ? null : super.func_184647_J();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_195064_c(EffectInstance effect) {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.ANCIENT_CAVERN.type()) {
            Entity source = cause.func_76346_g();
            ServerPlayerEntity killer = null;
            if (source != null) {
                if (source instanceof PlayerEntity) {
                    killer = (ServerPlayerEntity)source;
                } else if (source instanceof TameableEntity && ((TameableEntity)source).func_70902_q() instanceof PlayerEntity) {
                    killer = (ServerPlayerEntity)((TameableEntity)source).func_70902_q();
                }
            }
            if (killer != null) {
                PlayerUtil.addTributeToPlayer(killer, Deities.LUXON, 8);
            }
        }
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76437_t, 60).level(2).hideParticles());
            EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_188424_y, 60).hideParticles());
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_188424_y, 60).hideParticles());
        }
    }
}

