/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.immortallis;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class GhastusEntity
extends AoAMeleeMob {
    public GhastusEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.5625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 15.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 10.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_APPARITION_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_APPARITION_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_APPARITION_HURT.get();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_70691_i(1.0f);
    }

    public void func_70645_a(DamageSource cause) {
        Entity attacker;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.IMMORTALLIS.type() && ((attacker = cause.func_76346_g()) instanceof PlayerEntity || attacker instanceof TameableEntity)) {
            PlayerEntity pl = null;
            if (attacker instanceof TameableEntity) {
                if (((TameableEntity)attacker).func_70902_q() instanceof PlayerEntity) {
                    pl = (PlayerEntity)((TameableEntity)attacker).func_70902_q();
                }
            } else {
                pl = (PlayerEntity)attacker;
            }
            if (pl instanceof ServerPlayerEntity) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)pl);
                plData.stats().addTribute(Deities.EREBON, 4);
                if (plData.stats().getTribute(Deities.EREBON) == 200) {
                    plData.sendThrottledChatMessage("message.feedback.immortallisProgression.evilSpiritsEnd", new Object[0]);
                }
            }
        }
    }
}

