/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.immortallis;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class SkeledonEntity
extends AoAMeleeMob {
    private int cloakCooldown = 80;

    public SkeledonEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.1875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 120.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 11.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void func_70636_d() {
        super.func_70636_d();
        --this.cloakCooldown;
        if (this.cloakCooldown == 0) {
            this.cloakCooldown = 80;
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 1.0, 0.5));
            EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76441_p, 20));
        }
    }

    public void func_70645_a(DamageSource cause) {
        Entity attacker;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.IMMORTALLIS.type() && ((attacker = cause.func_76346_g()) instanceof PlayerEntity || attacker instanceof TameableEntity)) {
            ServerPlayerEntity pl = null;
            if (attacker instanceof TameableEntity) {
                if (((TameableEntity)attacker).func_70902_q() instanceof ServerPlayerEntity) {
                    pl = (ServerPlayerEntity)((TameableEntity)attacker).func_70902_q();
                }
            } else {
                pl = (ServerPlayerEntity)attacker;
            }
            if (pl != null) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                if (plData.stats().getTribute(Deities.EREBON) < 100) {
                    plData.stats().addTribute(Deities.EREBON, Math.min(4, 100 - plData.stats().getTribute(Deities.EREBON)));
                }
                if (plData.stats().getTribute(Deities.EREBON) >= 100) {
                    plData.sendThrottledChatMessage("message.feedback.immortallisProgression.skeletalSpiritsEnd", new Object[0]);
                }
            }
        }
    }
}

