/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.immortallis;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class UrvEntity
extends AoAMeleeMob {
    public UrvEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 75.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 14.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.25;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_AUTOMATON_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_AUTOMATON_HURT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GOLEM_STEP.get();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public void func_70645_a(DamageSource cause) {
        Entity attacker;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.IMMORTALLIS.type() && ((attacker = cause.func_76346_g()) instanceof PlayerEntity || attacker instanceof TameableEntity)) {
            ServerPlayerEntity pl = null;
            if (attacker instanceof TameableEntity) {
                if (((TameableEntity)attacker).func_70902_q() instanceof ServerPlayerEntity) {
                    pl = (ServerPlayerEntity)((TameableEntity)attacker).func_70902_q();
                }
            } else {
                pl = (ServerPlayerEntity)attacker;
            }
            if (pl != null) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                plData.stats().addTribute(Deities.EREBON, 4);
                if (plData.stats().getTribute(Deities.EREBON) == 200) {
                    plData.sendThrottledChatMessage("message.feedback.immortallisProgression.evilSpiritsEnd", new Object[0]);
                }
            }
        }
    }
}

