/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.immortallis;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class VisageEntity
extends AoAMeleeMob {
    private VisageEntity mirageHost = null;

    public VisageEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    public VisageEntity(VisageEntity mirageHost) {
        this((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.VISAGE.get()), mirageHost.field_70170_p);
        this.mirageHost = mirageHost;
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.46875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 60.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 11.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_PENUMBRA_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_PENUMBRA_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_PENUMBRA_HURT.get();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.mirageHost != null) {
            this.func_70106_y();
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.mirageHost != null) {
                if (this.field_70173_aa >= 600 || !this.mirageHost.func_70089_S()) {
                    this.func_70106_y();
                }
            } else if (RandomUtil.oneInNChance(200)) {
                VisageEntity visage = new VisageEntity(this);
                BlockPos newPos = RandomUtil.getRandomPositionWithinRange(this.func_180425_c(), 5, 0, 5, true, this.field_70170_p);
                visage.func_70107_b(newPos.func_177958_n(), newPos.func_177956_o(), newPos.func_177952_p());
                this.field_70170_p.func_217376_c((Entity)visage);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        Entity attacker;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.IMMORTALLIS.type() && ((attacker = cause.func_76346_g()) instanceof PlayerEntity || attacker instanceof TameableEntity)) {
            ServerPlayerEntity pl = null;
            if (attacker instanceof TameableEntity) {
                if (((TameableEntity)attacker).func_70902_q() instanceof ServerPlayerEntity) {
                    pl = (ServerPlayerEntity)((TameableEntity)attacker).func_70902_q();
                }
            } else {
                pl = (ServerPlayerEntity)attacker;
            }
            if (pl != null) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                plData.stats().addTribute(Deities.EREBON, 4);
                if (plData.stats().getTribute(Deities.EREBON) == 200) {
                    plData.sendThrottledChatMessage("message.feedback.immortallisProgression.evilSpiritsEnd", new Object[0]);
                }
            }
        }
    }
}

