/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.lelyetia;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.RandomUtil;

public class FlyeEntity
extends AoAFlyingMeleeMob {
    private static final DataParameter<BlockPos> ALTAR_POS = EntityDataManager.func_187226_a(FlyeEntity.class, (IDataSerializer)DataSerializers.field_187200_j);
    private BlockPos altarPos = null;

    public FlyeEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
    }

    public FlyeEntity(World world, BlockPos altarPos) {
        this((EntityType<? extends FlyingEntity>)((EntityType)AoAEntities.Mobs.FLYE.get()), world);
        BlockPos spawnPos;
        this.field_70180_af.func_187227_b(ALTAR_POS, (Object)altarPos);
        while (world.func_180495_p(spawnPos = RandomUtil.getRandomPositionWithinRange(altarPos, 20, 20, 20)).func_185904_a().func_76230_c()) {
        }
        this.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
        EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_188423_x, 9999999).isAmbient().hideParticles());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ALTAR_POS, (Object)BlockPos.field_177992_a);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.2f;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 50.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 6.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_FLYE_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_FLYE_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_FLYE_HURT.get();
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == ALTAR_POS) {
            this.altarPos = (BlockPos)this.field_70180_af.func_187225_a(ALTAR_POS);
            if (this.altarPos == BlockPos.field_177992_a) {
                this.altarPos = null;
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.altarPos != null) {
            compound.func_74772_a("GrawAltarPos", this.altarPos.func_218275_a());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("GrawAltarPos")) {
            this.altarPos = BlockPos.func_218283_e((long)compound.func_74763_f("GrawAltarPos"));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.altarPos != null && this.field_70170_p.func_82737_E() % 40L == 0L && !this.altarPos.func_218141_a((Vec3i)this.func_180425_c(), 30.0)) {
            double posX = ((float)this.altarPos.func_177958_n() + this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 10.0f;
            double posY = ((float)this.altarPos.func_177956_o() + this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 10.0f;
            double posZ = ((float)this.altarPos.func_177952_p() + this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 10.0f;
            this.func_70605_aq().func_75642_a(posX, posY, posZ, 1.0);
        }
    }

    public int func_226263_P_() {
        if (this.getGrawAltarPos() != null) {
            return NumberUtil.RGB(0, 255, 0);
        }
        return super.func_226263_P_();
    }

    @Nullable
    public BlockPos getGrawAltarPos() {
        return this.altarPos;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity pl;
            if (this.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.LELYETIA.type() && DamageUtil.isMeleeDamage(cause) && cause.func_76346_g() instanceof PlayerEntity && (pl = (PlayerEntity)cause.func_76346_g()).func_226278_cu_() >= 80.0 && ItemUtil.findInventoryItem(pl, new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
                ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((IItemProvider)AoAItems.HAVEN_REALMSTONE.get()));
            }
            if (this.altarPos != null && this.field_70718_bc > 0) {
                this.func_70099_a(new ItemStack((IItemProvider)AoAItems.GUARDIANS_EYE.get()), 0.0f);
            }
        }
    }
}

