/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.lunalus;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.base.AoAFlyingRangedMob;
import net.tslat.aoa3.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.item.weapon.bow.BaseBow;

public class LunarcherEntity
extends AoAFlyingRangedMob {
    public LunarcherEntity(EntityType<? extends FlyingEntity> entityType, World world) {
        super(entityType, world);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)AoAWeapons.LUNAR_BOW.get()));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
        return data;
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 118.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 14.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_LUNARCHER_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_LUNARCHER_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_LUNARCHER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundEvents.field_187737_v;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }

    @Override
    public void func_82196_d(@Nonnull LivingEntity target, float bowDamageFactor) {
        CustomArrowEntity projectile = new CustomArrowEntity(this.field_70170_p, (BaseBow)AoAWeapons.LUNAR_BOW.get(), (LivingEntity)this, this.getBaseProjectileDamage());
        double distanceFactorX = target.func_226277_ct_() - projectile.func_226277_ct_();
        double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - projectile.func_226278_cu_();
        double distanceFactorZ = target.func_226281_cx_() - projectile.func_226281_cx_();
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
        if (this.getShootSound() != null) {
            this.func_184185_a(this.getShootSound(), 1.0f, 1.0f);
        }
        projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_217376_c((Entity)projectile);
    }
}

