/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.misc;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.ElusiveEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ElusiveCloneEntity
extends AoAMeleeMob {
    private final ElusiveEntity elusive;

    public ElusiveCloneEntity(ElusiveEntity elusive) {
        super((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.ELUSIVE_CLONE.get()), elusive.field_70170_p);
        this.func_70012_b(elusive.func_226277_ct_(), elusive.func_226278_cu_(), elusive.func_226281_cx_(), elusive.field_70177_z, elusive.field_70125_A);
        this.elusive = elusive;
    }

    public ElusiveCloneEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.elusive = null;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.5f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 30.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 8.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_ELUSIVE_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_ELUSIVE_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_ELUSIVE_HURT.get();
    }

    @Override
    protected void onAttack(Entity target) {
        EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76440_q, 80).level(3));
        EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76441_p, 40));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.elusive == null) {
            this.func_70106_y();
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.elusive != null) {
            WorldUtil.createExplosion((Entity)this.elusive, this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 2.0f);
        }
    }
}

