/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.mysterium;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;

public class RunicGolemEntity
extends AoAMeleeMob {
    private static final DataParameter<Boolean> SHIELDED = EntityDataManager.func_187226_a(RunicGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int shieldCooldown = 120;
    private int runeStoneCooldown = 0;

    public RunicGolemEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.59375f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHIELDED, (Object)false);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 95.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 9.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.265;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_RUNIC_GOLEM_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_RUNIC_GOLEM_HURT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return SoundEvents.field_187605_cG;
    }

    public void deactivateShield() {
        this.shieldCooldown = 120;
        this.setShielded(false);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.isShielded()) {
            if (DamageUtil.isMeleeDamage(source) && this.runeStoneCooldown <= 0) {
                this.runeStoneCooldown = 120;
                this.func_199702_a((IItemProvider)AoAItems.ACTIVE_RUNE_STONE.get(), 1);
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_190530_aW() {
        return super.func_190530_aW() || this.isShielded();
    }

    public boolean func_180431_b(DamageSource source) {
        return this.func_190530_aW() || super.func_180431_b(source);
    }

    public boolean isShielded() {
        return (Boolean)this.field_70180_af.func_187225_a(SHIELDED);
    }

    private void setShielded(boolean shielded) {
        this.field_70180_af.func_187227_b(SHIELDED, (Object)shielded);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.runeStoneCooldown > 0) {
            --this.runeStoneCooldown;
        }
        if (this.shieldCooldown > 0) {
            --this.shieldCooldown;
        } else if (this.shieldCooldown == 0) {
            this.shieldCooldown = -1;
            this.func_184185_a((SoundEvent)AoASounds.ENTITY_RUNIC_GOLEM_CHARGE.get(), 1.0f, 1.0f);
            this.setShielded(true);
        }
    }
}

