/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.nether;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class InfernalEntity
extends AoAMeleeMob {
    public InfernalEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.71875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 95.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 8.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.25;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_INFERNAL_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_INFERNAL_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_INFERNAL_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_VERY_HEAVY_STEP.get();
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            DamageUtil.doBodySlamKnockback((LivingEntity)target, (Entity)this, 10.5f, 0.5f, 10.5f);
        }
    }

    @Override
    protected void onHit(DamageSource source, float amount) {
        if (DamageUtil.isMeleeDamage(source) && (!(source.func_76346_g() instanceof PlayerEntity) || PlayerUtil.shouldPlayerBeAffected((PlayerEntity)source.func_76346_g()))) {
            source.func_76346_g().func_70015_d(5);
        }
    }
}

