/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.overworld;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.EntityUtil;

public class ChomperEntity
extends AoAMeleeMob {
    private static final AttributeModifier BLOODTHIRSTY_BUFF = new AttributeModifier(UUID.fromString("2803f9b4-57ed-471f-8a0e-7a41fa100608"), "AoABloodthirstyBuff", 1.05, AttributeModifier.Operation.MULTIPLY_BASE);

    public ChomperEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.25f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.2;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 30.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 2.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    public void func_70624_b(@Nullable LivingEntity target) {
        if (target == null) {
            EntityUtil.removeAttributeModifier((LivingEntity)this, SharedMonsterAttributes.field_111263_d, BLOODTHIRSTY_BUFF);
        } else {
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, SharedMonsterAttributes.field_111263_d, BLOODTHIRSTY_BUFF);
        }
        super.func_70624_b(target);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CHOMPER_AMBIENT.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CHOMPER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 2, true, true));
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }
}

