/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.overworld;

import javax.annotation.Nullable;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.ClownShotEntity;
import net.tslat.aoa3.util.ItemUtil;

public class ClownEntity
extends AoARangedMob {
    public ClownEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)AoAWeapons.CONFETTI_CANNON.get()));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
        return data;
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.8125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 20.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 4.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_CLOWN_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_CLOWN_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CLOWN_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_CLOWN_SHOOT.get();
    }

    @Override
    protected int getMaxSpawnHeight() {
        return 50;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new ClownShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity pl;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && cause.func_76346_g() instanceof PlayerEntity && (pl = (PlayerEntity)cause.func_76346_g()).func_184586_b(Hand.MAIN_HAND).func_77973_b() == AoAWeapons.LELYETIAN_GREATBLADE.get() && ItemUtil.findInventoryItem(pl, new ItemStack((IItemProvider)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
            ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((IItemProvider)AoAItems.CELEVE_REALMSTONE.get()));
        }
    }
}

