/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.overworld;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.HagShotEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;

public class HagEntity
extends AoARangedMob {
    public HagEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.5625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 15.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 4.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_HAG_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_HAG_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_HAG_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_HAG_SHOOT.get();
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new HagShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 120));
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }
}

