/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.overworld;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;

public class TreeSpiritEntity
extends AoAMeleeMob {
    public TreeSpiritEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 2.4f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 35.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 6.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_AMBIENT.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_DEATH.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_HURT.get();
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof LivingEntity) {
            DamageUtil.doBodySlamKnockback((LivingEntity)target, (Entity)this, 5.0f, 1.0f, 5.0f);
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 50));
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }
}

