/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.overworld;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.mob.overworld.TricksterCloneEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PotionUtil;

public class TricksterEntity
extends AoAMeleeMob {
    private int invisCooldown = 160;
    private int cloneCooldown = 0;
    private HashSet<TricksterCloneEntity> clones = new HashSet();

    public TricksterEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.65f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 35.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 4.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Override
    public int getMaxSpawnHeight() {
        return 20;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_TRICKSTER_AMBIENT.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_TRICKSTER_HURT.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_TRICKSTER_HURT.get();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70089_S()) {
            return;
        }
        if (this.invisCooldown > 0) {
            --this.invisCooldown;
        }
        if (this.cloneCooldown > 1) {
            --this.cloneCooldown;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.invisCooldown == 0) {
                this.cloneCooldown = 60;
                this.invisCooldown = 240;
                EntityUtil.applyPotions((Entity)this, new PotionUtil.EffectBuilder(Effects.field_76441_p, 60));
                this.func_184185_a((SoundEvent)AoASounds.ENTITY_TRICKSTER_HIDE.get(), 1.0f, 1.0f);
            }
            if (this.cloneCooldown == 1 && this.field_70170_p.func_217357_a(TricksterCloneEntity.class, this.func_174813_aQ().func_186662_g(10.0)).size() < 5) {
                TricksterCloneEntity clone = new TricksterCloneEntity((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.TRICKSTER_CLONE.get()), this.field_70170_p);
                clone.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                this.field_70170_p.func_217376_c((Entity)clone);
                this.clones.add(clone);
                this.cloneCooldown = 0;
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            for (TricksterCloneEntity clone : this.clones) {
                clone.func_70106_y();
            }
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }
}

