/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.overworld.bloodhunt;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerUtil;

public class BloodmistEntity
extends AoAMeleeMob {
    public BloodmistEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.55f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 40.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 5.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.26;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_BLOODMIST_AMBIENT.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_BLOODMIST_DEATH.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_BLOODMIST_HURT.get();
    }

    @Override
    protected void onAttack(Entity target) {
        if (target instanceof ServerPlayerEntity) {
            PlayerUtil.consumeResource((ServerPlayerEntity)target, Resources.ENERGY, 40.0f, true);
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    @Nonnull
    protected OverworldEvents.Event getEventRequirement() {
        return OverworldEvents.Event.BLOOD_HUNT;
    }
}

