/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.overworld.creepday;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.minion.AoAMinion;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.util.RandomUtil;

public class HostEntity
extends AoAMeleeMob {
    public HostEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AoAMinion.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.85f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 120.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 0.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)AoASounds.ENTITY_HOST_AMBIENT.get();
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_HOST_DEATH.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_HOST_AMBIENT.get();
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        Vec3d motion = this.func_213322_ci();
        double motionY = motion.func_82617_b();
        if (this.field_70160_al && motionY < 0.0) {
            motionY *= 0.8;
        }
        if (this.func_70638_az() == null ? RandomUtil.oneInNChance(100) : RandomUtil.oneInNChance(10)) {
            motionY += 0.3;
        }
        this.func_213293_j(motion.func_82615_a(), motionY, motion.func_82616_c());
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && RandomUtil.oneInNChance(80)) {
            CreeperEntity creeper = new CreeperEntity(EntityType.field_200797_k, this.field_70170_p);
            creeper.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            this.field_70170_p.func_217376_c((Entity)creeper);
            this.func_184185_a((SoundEvent)AoASounds.ENTITY_HOST_SUMMON.get(), 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    @Nonnull
    protected OverworldEvents.Event getEventRequirement() {
        return OverworldEvents.Event.CREEP_DAY;
    }
}

