/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.overworld.deathday;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.util.RandomUtil;

public class HeadlessDestroyerEntity
extends AoAMeleeMob {
    public HeadlessDestroyerEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.7f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.3f;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 55.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 9.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.25;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)AoASounds.ENTITY_SLIMER_DEATH.get();
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_SLIMER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_VERY_HEAVY_STEP.get();
    }

    @Override
    protected boolean isDaylightMob() {
        return true;
    }

    public void func_70074_a(LivingEntity victim) {
        if (victim instanceof PlayerEntity && RandomUtil.oneInNChance(10)) {
            ItemStack headStack = new ItemStack((IItemProvider)Items.field_196184_dx);
            CompoundNBT tag = headStack.func_196082_o();
            tag.func_74778_a("SkullOwner", ((PlayerEntity)victim).func_146103_bH().getName());
            this.func_199701_a_(headStack);
        }
    }

    @Override
    protected boolean isOverworldMob() {
        return true;
    }

    @Override
    @Nonnull
    protected OverworldEvents.Event getEventRequirement() {
        return OverworldEvents.Event.DEATH_DAY;
    }
}

