/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.precasia;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.block.functional.altar.ArmyBlock;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.base.AoAMeleeMob;

public class SkeleElderEntity
extends AoAMeleeMob {
    private BlockPos armyBlockPos;
    private int wave;

    public SkeleElderEntity(World world, BlockPos armyBlockPos, int wave) {
        super((EntityType<? extends MonsterEntity>)((EntityType)AoAEntities.Mobs.SKELE_ELDER.get()), world);
        this.armyBlockPos = armyBlockPos;
        this.wave = wave;
        this.func_213390_a(armyBlockPos, 18);
    }

    public SkeleElderEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
        this.armyBlockPos = null;
        this.wave = -1;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.armyBlockPos == null || this.wave < 0;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize size) {
        return 2.34375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 60.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 3.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.25;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("SkeletalArmyWave")) {
            this.wave = compound.func_74762_e("SkeletalArmyWave");
        }
        if (compound.func_74764_b("ArmyBlockPos")) {
            this.armyBlockPos = BlockPos.func_218283_e((long)compound.func_74763_f("ArmyBlockPos"));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.wave > 0) {
            compound.func_74768_a("SkeletalArmyWave", this.wave);
        }
        if (this.armyBlockPos != null) {
            compound.func_74772_a("ArmyBlockPos", this.armyBlockPos.func_218275_a());
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public void func_70645_a(DamageSource cause) {
        Block bl;
        super.func_70645_a(cause);
        if (this.wave >= 0 && this.armyBlockPos != null && this.func_70092_e(this.armyBlockPos.func_177958_n(), this.armyBlockPos.func_177956_o(), this.armyBlockPos.func_177952_p()) < 2500.0 && (bl = this.field_70170_p.func_180495_p(this.armyBlockPos).func_177230_c()) == AoABlocks.ARMY_BLOCK.get()) {
            ArmyBlock.spawnWave(this.field_70170_p, this.armyBlockPos, this.wave + 1);
        }
    }
}

