/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.runandor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectile.mob.HeavyRunicGuardianShotEntity;
import net.tslat.aoa3.entity.projectile.mob.LightRunicGuardianShotEntity;
import net.tslat.aoa3.entity.projectile.mob.RunicGuardianShotEntity;

public class RunicGuardianEntity
extends AoARangedMob {
    public RunicGuardianEntity(EntityType<? extends MonsterEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 109.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 13.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    @Override
    public void func_82196_d(@Nonnull LivingEntity target, float bowDamageFactor) {
        LightRunicGuardianShotEntity projectile1 = new LightRunicGuardianShotEntity(this, BaseMobProjectile.Type.MAGIC);
        RunicGuardianShotEntity projectile2 = new RunicGuardianShotEntity(this, BaseMobProjectile.Type.MAGIC);
        HeavyRunicGuardianShotEntity projectile3 = new HeavyRunicGuardianShotEntity(this, BaseMobProjectile.Type.MAGIC);
        double distanceFactorX = target.func_226277_ct_() - this.func_226277_ct_();
        double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - projectile1.func_226278_cu_();
        double distanceFactorZ = target.func_226281_cx_() - this.func_226281_cx_();
        double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) + 0.2;
        if (this.getShootSound() != null) {
            this.func_184185_a(this.getShootSound(), 1.0f, 1.0f);
        }
        projectile1.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        projectile2.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        projectile3.func_70186_c(distanceFactorX, distanceFactorY + hyp * (double)0.2f, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
        this.field_70170_p.func_217376_c((Entity)projectile1);
        this.field_70170_p.func_217376_c((Entity)projectile2);
        this.field_70170_p.func_217376_c((Entity)projectile3);
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_WIZARD_SHOOT.get();
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }
}

