/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mob.runandor.templars;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.mob.runandor.templars.RunicLifeformEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LootUtil;

public abstract class RuneTemplarEntity
extends CreatureEntity {
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()), BossInfo.Color.GREEN, BossInfo.Overlay.NOTCHED_20).func_186741_a(false).func_186743_c(false);
    private static final DataParameter<Boolean> DISABLED = EntityDataManager.func_187226_a(RuneTemplarEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final HashSet<RunicLifeformEntity> lifeforms = new HashSet();
    public static final float entityWidth = 1.125f;
    public static final float entityHeight = 2.0f;

    public RuneTemplarEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 1.8125f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DISABLED, (Object)true);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187689_f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187689_f;
    }

    private void changeState(boolean disabled) {
        this.field_70180_af.func_187227_b(DISABLED, (Object)disabled);
    }

    public boolean isDisabled() {
        return (Boolean)this.field_70180_af.func_187225_a(DISABLED);
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    protected abstract RunicLifeformEntity getLifeForm();

    protected abstract RuneItem getActivationRune();

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_200600_R().func_212546_e().func_212638_h().func_150257_a(this.func_145748_c_()));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public boolean func_180427_aV() {
        return true;
    }

    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (this.isDisabled() && heldStack.func_77973_b() == this.getActivationRune()) {
            if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.RUNIC_ENERGY.get()), true, 1)) {
                this.changeState(false);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && !this.isDisabled()) {
            this.func_70606_j(this.func_110143_aJ() - 0.25f);
            if (this.func_110143_aJ() < 1.0f) {
                this.doDrops();
                this.changeState(true);
                this.func_70606_j(this.func_110138_aP());
                for (RunicLifeformEntity lifeforms : this.lifeforms) {
                    lifeforms.func_70106_y();
                }
            } else if (this.field_70146_Z.nextInt(125) == 0 && this.field_70170_p.func_217357_a(RunicLifeformEntity.class, this.func_174813_aQ().func_72314_b(6.0, 3.0, 6.0)).size() <= 4) {
                RunicLifeformEntity lifeform = this.getLifeForm();
                int coordX = (int)this.func_226277_ct_() - 3 + this.field_70146_Z.nextInt(6);
                int coordZ = (int)this.func_226281_cx_() - 3 + this.field_70146_Z.nextInt(6);
                lifeform.func_70012_b(coordX, this.func_226278_cu_(), coordZ, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)lifeform);
                this.lifeforms.add(lifeform);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
    }

    protected void func_213354_a(DamageSource damageSourceIn, boolean p_213354_2_) {
        super.func_213354_a(damageSourceIn, p_213354_2_);
    }

    private void doDrops() {
        float luck = 0.0f;
        for (PlayerEntity pl : this.field_70170_p.func_217357_a(PlayerEntity.class, this.func_174813_aQ().func_186662_g(8.0))) {
            float plLuck = pl.func_184817_da();
            if (!(plLuck > luck)) continue;
            luck = plLuck;
        }
        if (!this.field_70170_p.func_201670_d()) {
            LootTable table = LootUtil.getTable((ServerWorld)this.field_70170_p, this.func_184647_J());
            for (ItemStack stack : table.func_216113_a(this.func_213363_a(false, DamageSource.field_76377_j).func_216022_a(LootParameterSets.field_216263_d))) {
                this.func_70099_a(stack, 0.0f);
            }
        }
    }
}

