/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.npc.banker;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.container.BankerContainer;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.base.AoATrader;
import net.tslat.aoa3.entity.npc.AoATraderRecipe;

public class CreepBankerEntity
extends AoATrader {
    public CreepBankerEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected double getBaseMaxHealth() {
        return 30.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.field_70170_p.func_201675_m().func_186058_p() != AoADimensions.CREEPONIA.type();
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == AoAItems.BLANK_REALMSTONE.get() && heldStack.func_77973_b().func_111207_a(heldStack, player, (LivingEntity)this, hand)) {
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void openGui(PlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return CreepBankerEntity.this.func_145748_c_();
            }

            @Nullable
            public Container createMenu(int screenId, PlayerInventory inv, PlayerEntity player) {
                return new BankerContainer(screenId, player.field_71071_by, CreepBankerEntity.this);
            }
        }, buffer -> buffer.writeInt(this.func_145782_y()));
    }

    @Override
    protected boolean isFixedTradesList() {
        return true;
    }

    @Override
    protected void getTradesList(NonNullList<AoATraderRecipe> newTradesList) {
        newTradesList.add((Object)new AoATraderRecipe(ItemStack.field_190927_a, ItemStack.field_190927_a));
    }
}

