/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.arrow;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.item.weapon.bow.BaseBow;
import net.tslat.aoa3.item.weapon.crossbow.BaseCrossbow;

public class CustomArrowEntity
extends ArrowEntity {
    protected BaseBow bow;
    protected BaseCrossbow crossbow;
    private boolean ignoreExplosions = false;

    public CustomArrowEntity(EntityType<? extends ArrowEntity> type, World world) {
        super(type, world);
    }

    public CustomArrowEntity(World world, double x, double y, double z) {
        super((EntityType)AoAEntities.Projectiles.ARROW.get(), world);
        this.func_70107_b(x, y, z);
    }

    public CustomArrowEntity(World world, BaseBow bow, LivingEntity shooter, double baseDamage) {
        super((EntityType)AoAEntities.Projectiles.ARROW.get(), world);
        this.func_212361_a((Entity)shooter);
        this.func_70239_b(baseDamage);
        this.bow = bow;
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_());
    }

    public CustomArrowEntity(World world, BaseCrossbow crossbow, LivingEntity shooter, double baseDamage) {
        super((EntityType)AoAEntities.Projectiles.ARROW.get(), world);
        this.func_212361_a((Entity)shooter);
        this.func_70239_b(baseDamage);
        this.crossbow = crossbow;
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_());
    }

    public static CustomArrowEntity fromArrow(AbstractArrowEntity baseArrow, BaseBow bow, LivingEntity shooter, double baseDamage) {
        CustomArrowEntity arrow = new CustomArrowEntity((EntityType<? extends ArrowEntity>)((EntityType)AoAEntities.Projectiles.ARROW.get()), baseArrow.field_70170_p);
        arrow.func_212361_a((Entity)shooter);
        arrow.func_70239_b(baseDamage);
        arrow.func_70240_a(baseArrow.field_70256_ap);
        arrow.func_70243_d(baseArrow.func_70241_g());
        arrow.func_70015_d(baseArrow.func_223314_ad());
        CustomArrowEntity.duplicateArrowVelocity(baseArrow, (AbstractArrowEntity)arrow);
        arrow.func_70107_b(shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_());
        if (baseArrow instanceof ArrowEntity) {
            ArrowEntity baseArrowEntity = (ArrowEntity)baseArrow;
            arrow.field_184560_g = baseArrowEntity.field_184560_g;
            arrow.field_184561_h = baseArrowEntity.field_184561_h;
            arrow.func_191507_d(baseArrowEntity.func_184557_n());
        }
        arrow.bow = bow;
        return arrow;
    }

    public static CustomArrowEntity fromArrow(AbstractArrowEntity baseArrow, BaseCrossbow crossbow, LivingEntity shooter, double baseDamage) {
        CustomArrowEntity arrow = new CustomArrowEntity((EntityType<? extends ArrowEntity>)((EntityType)AoAEntities.Projectiles.ARROW.get()), baseArrow.field_70170_p);
        arrow.func_212361_a((Entity)shooter);
        arrow.func_70239_b(baseDamage);
        arrow.func_70240_a(baseArrow.field_70256_ap);
        arrow.func_70243_d(baseArrow.func_70241_g());
        arrow.func_70015_d(baseArrow.func_223314_ad());
        CustomArrowEntity.duplicateArrowVelocity(baseArrow, (AbstractArrowEntity)arrow);
        arrow.func_70107_b(shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.1f, shooter.func_226281_cx_());
        if (baseArrow instanceof ArrowEntity) {
            ArrowEntity baseArrowEntity = (ArrowEntity)baseArrow;
            arrow.field_184560_g = baseArrowEntity.field_184560_g;
            arrow.field_184561_h = baseArrowEntity.field_184561_h;
            arrow.func_191507_d(baseArrowEntity.func_184557_n());
        }
        arrow.crossbow = crossbow;
        return arrow;
    }

    protected static void duplicateArrowVelocity(AbstractArrowEntity source, AbstractArrowEntity target) {
        target.func_213317_d(source.func_213322_ci());
        target.field_70125_A = source.field_70125_A;
        target.field_70177_z = source.field_70177_z;
        target.field_70127_C = source.field_70127_C;
        target.field_70126_B = source.field_70126_B;
    }

    public void func_70071_h_() {
        if (this.bow != null) {
            this.bow.onArrowTick(this, this.func_212360_k());
        } else if (this.crossbow != null) {
            this.crossbow.onArrowTick(this, this.func_212360_k());
        }
        super.func_70071_h_();
    }

    public boolean func_180427_aV() {
        return this.ignoreExplosions;
    }

    public void setIgnoreExplosions() {
        this.ignoreExplosions = true;
    }

    protected void func_184549_a(RayTraceResult rayTrace) {
        if (rayTrace.func_216346_c() == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)rayTrace);
        } else if (rayTrace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockState blockstate;
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)rayTrace;
            this.field_195056_av = blockstate = this.field_70170_p.func_180495_p(blockTrace.func_216350_a());
            Vec3d vec3d = blockTrace.func_216347_e().func_178786_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            if (this.bow != null) {
                this.bow.onBlockHit(this, blockTrace, this.func_212360_k());
            } else if (this.crossbow != null) {
                this.crossbow.onBlockHit(this, blockTrace, this.func_212360_k());
            }
            this.func_213317_d(vec3d);
            Vec3d vec3d1 = vec3d.func_72432_b().func_186678_a((double)0.05f);
            this.func_226288_n_(this.func_226277_ct_() - vec3d1.field_72450_a, this.func_226278_cu_() - vec3d1.field_72448_b, this.func_226281_cx_() - vec3d1.field_72449_c);
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            this.func_213872_b((byte)0);
            this.func_213869_a(SoundEvents.field_187731_t);
            this.func_213865_o(false);
            if (this.field_213875_aA != null) {
                this.field_213875_aA.clear();
            }
            if (this.field_213878_az != null) {
                this.field_213878_az.clear();
            }
            blockstate.func_215690_a(this.field_70170_p, blockstate, blockTrace, (Entity)this);
        }
    }

    protected void func_213868_a(EntityRayTraceResult rayTrace) {
        DamageSource source;
        Entity shooter;
        Entity target = rayTrace.func_216348_a();
        float drawPower = (float)this.func_213322_ci().func_72433_c();
        double damage = this.func_70242_d();
        boolean critical = this.func_70241_g();
        if (this.bow != null) {
            damage = this.bow.getArrowDamage(this, target, damage, drawPower, critical);
        } else if (this.crossbow != null) {
            damage = this.crossbow.getArrowDamage(this, target, damage, drawPower, critical);
        }
        damage = Math.max(damage, 0.0);
        if (this.func_213874_s() > 0) {
            if (this.field_213878_az == null) {
                this.field_213878_az = new IntOpenHashSet(5);
            }
            if (this.field_213875_aA == null) {
                this.field_213875_aA = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.field_213878_az.size() >= this.func_213874_s() + 1) {
                this.func_70106_y();
                return;
            }
            this.field_213878_az.add(target.func_145782_y());
        }
        if ((shooter = this.func_212360_k()) == null) {
            source = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this);
        } else {
            source = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)shooter);
            if (shooter instanceof LivingEntity) {
                ((LivingEntity)shooter).func_130011_c(target);
            }
        }
        boolean isEnderman = target.func_200600_R() == EntityType.field_200803_q;
        int fireTimer = target.func_223314_ad();
        if (this.func_70027_ad() && !isEnderman) {
            target.func_70015_d(5);
        }
        if (target.func_70097_a(source, (float)damage)) {
            if (isEnderman) {
                return;
            }
            if (this.bow != null) {
                this.bow.onEntityHit(this, target, shooter, damage, drawPower);
            } else if (this.crossbow != null) {
                this.crossbow.onEntityHit(this, target, shooter, damage, drawPower);
            }
            if (target instanceof LivingEntity) {
                Vec3d vec3d;
                LivingEntity livingTarget = (LivingEntity)target;
                if (!this.field_70170_p.field_72995_K && this.func_213874_s() <= 0) {
                    livingTarget.func_85034_r(livingTarget.func_85035_bI() + 1);
                }
                if (this.field_70256_ap > 0 && (vec3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                    livingTarget.func_70024_g(vec3d.field_72450_a, 0.1, vec3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && shooter instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingTarget, (Entity)shooter);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)shooter), (Entity)livingTarget);
                }
                this.func_184548_a(livingTarget);
                if (livingTarget != shooter && livingTarget instanceof PlayerEntity && shooter instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)shooter).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                }
                if (!target.func_70089_S() && this.field_213875_aA != null) {
                    this.field_213875_aA.add(livingTarget);
                }
                if (!this.field_70170_p.field_72995_K && shooter instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)shooter;
                    if (this.field_213875_aA != null && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, (Collection)this.field_213875_aA, this.field_213875_aA.size());
                    } else if (!target.func_70089_S() && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, Arrays.asList(target), 0);
                    }
                }
            }
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0) {
                this.func_70106_y();
            }
        } else {
            target.func_223308_g(fireTimer);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.field_70257_an = 0;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

