/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.cannon;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEntities;
import net.tslat.aoa3.entity.projectile.HardProjectile;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.WorldUtil;

public class StickyCoolBombEntity
extends BaseBullet
implements HardProjectile {
    private BaseGun weapon;
    private LivingEntity shooter;
    private int ticksInGround = 0;

    public StickyCoolBombEntity(EntityType<? extends ThrowableEntity> entityType, World world) {
        super(entityType, world);
    }

    public StickyCoolBombEntity(World world) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.STICKY_COOL_BOMB.get()), world);
    }

    public StickyCoolBombEntity(LivingEntity shooter, BaseGun gun, Hand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.STICKY_COOL_BOMB.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
        this.weapon = gun;
        this.shooter = shooter;
    }

    public StickyCoolBombEntity(World world, double x, double y, double z) {
        super((EntityType<? extends ThrowableEntity>)((EntityType)AoAEntities.Projectiles.STICKY_COOL_BOMB.get()), world, x, y, z);
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)result;
            BlockState bl = this.field_70170_p.func_180495_p(rayTraceResult.func_216350_a());
            double posX = rayTraceResult.func_216350_a().func_177958_n();
            double posY = rayTraceResult.func_216350_a().func_177956_o();
            double posZ = rayTraceResult.func_216350_a().func_177952_p();
            if (!bl.func_185904_a().func_76230_c()) {
                return;
            }
            ++this.ticksInGround;
            this.func_213293_j(0.0, 0.0, 0.0);
            switch (rayTraceResult.func_216354_b()) {
                case UP: {
                    posY += 1.0;
                    break;
                }
                case DOWN: {
                    posY -= 1.0;
                    break;
                }
                case SOUTH: {
                    posZ += 0.5;
                    break;
                }
                case NORTH: {
                    posZ -= 0.5;
                    break;
                }
                case EAST: {
                    posX += 0.5;
                    break;
                }
                case WEST: {
                    posX -= 0.5;
                    break;
                }
            }
            this.func_70107_b(posX, posY, posZ);
        } else if (!this.field_70170_p.func_201670_d()) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.weapon.doImpactDamage(((EntityRayTraceResult)result).func_216348_a(), this.func_85052_h(), this, 1.0f);
                this.doImpactEffect();
            }
            this.func_70106_y();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.ticksInGround > 0) {
            this.func_213293_j(0.0, 0.0, 0.0);
            ++this.ticksInGround;
            if (this.ticksInGround >= 80 && !this.field_70170_p.field_72995_K) {
                this.doImpactEffect();
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70128_L = false;
            }
        }
    }

    @Override
    public void doImpactEffect() {
        WorldUtil.createExplosion((Entity)this.field_70192_c, this.field_70170_p, (Entity)this, 2.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

