/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.gun;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.entity.projectile.HardProjectile;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.item.weapon.thrown.BaseThrownWeapon;
import net.tslat.aoa3.util.WorldUtil;

public class BaseBullet
extends ThrowableEntity
implements HardProjectile {
    private float dmgMulti;
    private int lifespan;
    private int pierceCount;
    private int age = 0;
    private BaseGun weapon;
    private Entity lastPierceTarget;
    private Hand hand;

    public BaseBullet(EntityType<? extends ThrowableEntity> entityType, World world) {
        super(entityType, world);
    }

    public BaseBullet(EntityType<? extends ThrowableEntity> entityType, LivingEntity shooter, BaseGun gun, float dmgMultiplier, int piercingValue, float velocity) {
        super(entityType, shooter.field_70170_p);
        this.dmgMulti = dmgMultiplier;
        this.lifespan = 60;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.hand = Hand.MAIN_HAND;
        this.func_70012_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_(), shooter.field_70177_z, shooter.field_70125_A);
        float vectorX = -MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * MathHelper.func_76134_b((float)(this.field_70125_A * (float)Math.PI / 180.0f));
        float vectorY = -MathHelper.func_76126_a((float)(this.field_70125_A * (float)Math.PI / 180.0f));
        float vectorZ = MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * MathHelper.func_76134_b((float)(this.field_70125_A * (float)Math.PI / 180.0f));
        this.func_70186_c(vectorX, vectorY, vectorZ, velocity, 0.0f);
    }

    public BaseBullet(EntityType<? extends ThrowableEntity> entityType, LivingEntity shooter, BaseGun gun, Hand hand, int maxAge, float dmgMultiplier, int piercingValue, float xMod, float yMod, float zMod) {
        super(entityType, shooter.field_70170_p);
        this.dmgMulti = dmgMultiplier;
        this.lifespan = maxAge;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = hand;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_(), shooter.field_70177_z, shooter.field_70125_A);
        boolean right = true;
        if (shooter instanceof PlayerEntity) {
            if (hand == Hand.MAIN_HAND) {
                if (shooter.func_184591_cq() == HandSide.LEFT) {
                    right = false;
                }
            } else if (shooter.func_184591_cq() == HandSide.RIGHT) {
                right = false;
            }
        }
        this.func_70186_c(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * MathHelper.func_76134_b((float)(this.field_70125_A * (float)Math.PI / 180.0f)) + xMod, -MathHelper.func_76126_a((float)(this.field_70125_A * (float)Math.PI / 180.0f)) + yMod, MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * MathHelper.func_76134_b((float)(this.field_70125_A * (float)Math.PI / 180.0f)) + zMod, 3.0f, 2.0f);
        if (right) {
            this.func_70107_b(this.func_213322_ci().func_82615_a() * 0.5 + this.func_226277_ct_() - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.func_213322_ci().func_82617_b() * 0.5 + this.func_226278_cu_() - 0.3, this.func_213322_ci().func_82616_c() * 0.5 + this.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.func_70107_b(this.func_213322_ci().func_82615_a() * 0.5 + this.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.func_213322_ci().func_82617_b() * 0.5 + this.func_226278_cu_() - 0.3, this.func_213322_ci().func_82616_c() * 0.5 + this.func_226281_cx_() - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseBullet(EntityType<? extends ThrowableEntity> entityType, LivingEntity shooter, BaseGun gun, Hand hand, int maxAge, float dmgMultiplier, int piercingValue) {
        super(entityType, shooter.field_70170_p);
        boolean right;
        this.dmgMulti = dmgMultiplier;
        this.lifespan = maxAge;
        this.pierceCount = piercingValue;
        this.weapon = gun;
        this.hand = hand;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_(), shooter.field_70177_z, shooter.field_70125_A);
        boolean bl = right = shooter.func_184591_cq() == HandSide.RIGHT;
        if (shooter instanceof PlayerEntity) {
            if (hand == Hand.MAIN_HAND) {
                if (shooter.func_184591_cq() == HandSide.LEFT) {
                    right = false;
                }
            } else if (shooter.func_184591_cq() == HandSide.RIGHT) {
                right = false;
            }
        }
        this.func_70186_c(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * MathHelper.func_76134_b((float)(this.field_70125_A * (float)Math.PI / 180.0f)), -MathHelper.func_76126_a((float)(this.field_70125_A * (float)Math.PI / 180.0f)), MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * MathHelper.func_76134_b((float)(this.field_70125_A * (float)Math.PI / 180.0f)), 3.0f, 0.0f);
        if (right) {
            this.func_70107_b(this.func_213322_ci().func_82615_a() * 0.5 + this.func_226277_ct_() - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.func_213322_ci().func_82617_b() * 0.5 + this.func_226278_cu_() - 0.3, this.func_213322_ci().func_82616_c() * 0.5 + this.func_226281_cx_() + (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.func_70107_b(this.func_213322_ci().func_82615_a() * 0.5 + this.func_226277_ct_() + (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.func_213322_ci().func_82617_b() * 0.5 + this.func_226278_cu_() - 0.3, this.func_213322_ci().func_82616_c() * 0.5 + this.func_226281_cx_() - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        }
    }

    public BaseBullet(EntityType<? extends ThrowableEntity> entityType, World world, double x, double y, double z) {
        super(entityType, world);
        this.lifespan = 60;
        this.func_70107_b(x, y, z);
    }

    public void func_70186_c(double directionX, double directionY, double directionZ, float velocity, float inaccuracy) {
        Vec3d motionVec = new Vec3d(directionX, directionY, directionZ).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a((double)velocity);
        this.func_213317_d(motionVec);
        float lat = MathHelper.func_76133_a((double)BaseBullet.func_213296_b((Vec3d)motionVec));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)motionVec.field_72450_a, (double)motionVec.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)motionVec.field_72448_b, (double)lat) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (this.field_70170_p.field_72995_K || result.func_216346_c() == RayTraceResult.Type.MISS || !this.func_70089_S()) {
            return;
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            float hardness;
            BlockPos resultPos = ((BlockRayTraceResult)result).func_216350_a();
            BlockState bl = this.field_70170_p.func_180495_p(resultPos);
            if (WorldUtil.checkGameRule(this.field_70170_p, AoAGameRules.DESTRUCTIVE_WEAPON_PHYSICS) && (hardness = bl.func_185887_b((IBlockReader)this.field_70170_p, resultPos)) >= 0.0f && hardness <= 0.3f) {
                if (this.field_70146_Z.nextBoolean()) {
                    this.field_70170_p.func_175655_b(resultPos, true);
                } else {
                    this.field_70170_p.func_175656_a(resultPos, Blocks.field_150350_a.func_176223_P());
                }
                if (this.field_70146_Z.nextFloat() > hardness / 1.5f) {
                    return;
                }
            }
            if (!bl.func_185904_a().func_76230_c()) {
                return;
            }
            this.doImpactEffect();
        } else {
            Entity entityResult = ((EntityRayTraceResult)result).func_216348_a();
            if (entityResult != this.lastPierceTarget) {
                if (this.weapon == null) {
                    this.doEntityImpact(entityResult);
                } else {
                    this.weapon.doImpactDamage(entityResult, this.func_85052_h(), this, this.dmgMulti);
                }
                this.doImpactEffect();
                --this.pierceCount;
            }
            if (this.pierceCount >= 0) {
                this.lastPierceTarget = entityResult;
                return;
            }
        }
        this.func_70106_y();
    }

    public void doEntityImpact(Entity target) {
    }

    @Override
    public void doImpactEffect() {
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        AxisAlignedBB boundingBox;
        Vec3d position;
        if (!this.func_70089_S()) {
            return;
        }
        Vec3d motion = this.func_213322_ci();
        if (this.field_70173_aa == 1 && !(this.weapon instanceof BaseThrownWeapon)) {
            float mod = this.weapon instanceof BaseSniper ? 0.05f : 0.5f;
            position = new Vec3d(this.func_226277_ct_() - motion.func_82615_a() * (double)mod, this.func_226278_cu_() - motion.func_82617_b() * (double)mod, this.func_226281_cx_() - motion.func_82616_c() * (double)mod);
            boundingBox = new AxisAlignedBB(position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        } else {
            boundingBox = this.func_174813_aQ();
            position = new Vec3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        Vec3d velocityAdjustedPosition = new Vec3d(this.func_226277_ct_() + motion.func_82615_a(), this.func_226278_cu_() + motion.func_82617_b(), this.func_226281_cx_() + motion.func_82616_c());
        BlockRayTraceResult intersectedBlocksTrace = this.field_70170_p.func_217299_a(new RayTraceContext(position, velocityAdjustedPosition, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        velocityAdjustedPosition = intersectedBlocksTrace.func_216346_c() != RayTraceResult.Type.MISS ? new Vec3d(intersectedBlocksTrace.func_216347_e().field_72450_a, intersectedBlocksTrace.func_216347_e().field_72448_b, intersectedBlocksTrace.func_216347_e().field_72449_c) : new Vec3d(this.func_226277_ct_() + motion.func_82615_a(), this.func_226278_cu_() + motion.func_82617_b(), this.func_226281_cx_() + motion.func_82616_c());
        EntityRayTraceResult entityTrace = ProjectileHelper.func_221271_a((World)this.field_70170_p, (Entity)this, (Vec3d)position, (Vec3d)velocityAdjustedPosition, (AxisAlignedBB)boundingBox.func_72321_a(motion.func_82615_a(), motion.func_82617_b(), motion.func_82616_c()).func_186662_g(0.5), entity -> entity.func_70089_S() && entity.func_70067_L() && !entity.func_175149_v() && entity != this.field_184539_c);
        if (entityTrace != null) {
            intersectedBlocksTrace = entityTrace;
        }
        if (intersectedBlocksTrace.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)intersectedBlocksTrace)) {
            this.func_70184_a((RayTraceResult)intersectedBlocksTrace);
        }
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_174854_a || this.age > this.lifespan) {
                this.func_70106_y();
            } else {
                ++this.age;
            }
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public Hand getHand() {
        return this.hand;
    }

    public BaseBullet setMaxAge(int maxAge) {
        this.lifespan = maxAge;
        return this;
    }

    public BaseBullet setPierceCount(int pierceCount) {
        this.pierceCount = pierceCount;
        return this;
    }

    public int getAge() {
        return this.age;
    }

    @Nullable
    public BaseGun getWeapon() {
        return this.weapon;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

