/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectile.mob;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.tslat.aoa3.entity.base.AoARangedAttacker;

public abstract class BaseMobProjectile
extends ThrowableEntity {
    private Type projectileType;
    private AoARangedAttacker shooter;

    public BaseMobProjectile(EntityType<? extends ThrowableEntity> entityType, World world) {
        super(entityType, world);
    }

    public BaseMobProjectile(EntityType<? extends ThrowableEntity> entityType, World world, AoARangedAttacker shooter, double posX, double posY, double posZ, Type projectileType) {
        super(entityType, world);
        this.func_70107_b(posX, posY, posZ);
        this.func_213293_j(this.field_70146_Z.nextGaussian() / 33.0 + 0.03, -2.0, this.field_70146_Z.nextGaussian() / 33.0 + 0.03);
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public BaseMobProjectile(EntityType<? extends ThrowableEntity> entityType, World world, AoARangedAttacker shooter, Entity target, Type projectileType) {
        this(entityType, world, shooter, target.func_226277_ct_(), target.func_226278_cu_() + 25.0, target.func_226281_cx_(), projectileType);
    }

    public BaseMobProjectile(EntityType<? extends ThrowableEntity> entityType, World world, AoARangedAttacker shooter, Type projectileType) {
        super(entityType, world);
        if (shooter instanceof LivingEntity) {
            this.field_70192_c = (LivingEntity)shooter;
            this.func_70107_b(this.field_70192_c.func_226277_ct_(), this.field_70192_c.func_226278_cu_() + (double)this.field_70192_c.func_70047_e() - (double)0.1f, this.field_70192_c.func_226281_cx_());
        }
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public Type getProjectileType() {
        return this.projectileType;
    }

    public float func_70185_h() {
        return 0.0f;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 500) {
            this.func_70106_y();
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if ((result.func_216346_c() != RayTraceResult.Type.BLOCK || this.field_70170_p.func_180495_p(new BlockPos(result.func_216347_e())).func_185904_a().func_76230_c()) && !this.field_70170_p.field_72995_K) {
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                if (result.hitInfo == this.shooter || this.shooter == null) {
                    return;
                }
                this.shooter.doProjectileEntityImpact(this, ((EntityRayTraceResult)result).func_216348_a());
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK && this.shooter != null) {
                this.shooter.doProjectileBlockImpact(this, this.field_70170_p.func_180495_p(new BlockPos(result.func_216347_e())), new BlockPos(result.func_216347_e()), ((BlockRayTraceResult)result).func_216354_b());
            }
            this.func_70106_y();
        }
    }

    public boolean func_180427_aV() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        MAGIC,
        PHYSICAL,
        GUN,
        OTHER;

    }
}

